/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.guava25.base.Function;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagnosticsProviderJvmFatalErrorMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiagnosticsProviderJvmFatalErrorMapper.class);
    private static DiagnosticsProviderJvmFatalErrorMapper diagnosticsProviderJvmFatalErrorMapper = new DiagnosticsProviderJvmFatalErrorMapper();
    private final AtomicReference<Function<Error, Exception>> fatalErrorMapper = new AtomicReference();
    private final AtomicLong mapperExecutionCount = new AtomicLong(0L);

    public void registerFatalErrorMapper(Function<Error, Exception> fatalErrorMapper) {
        LOGGER.info("Register diagnostics provider fatal error mapper");
        this.fatalErrorMapper.set(fatalErrorMapper);
    }

    public Exception mapFatalError(Error error) {
        if (error == null || this.fatalErrorMapper.get() == null) {
            return null;
        }
        return this.mapToException(error);
    }

    private Exception mapToException(Error error) {
        try {
            this.mapperExecutionCount.getAndIncrement();
            Exception mappedException = this.fatalErrorMapper.get().apply(error);
            if (mappedException != null) {
                LOGGER.info("Mapping from Error {} to Exception {}", error.getClass(), mappedException.getClass());
                return mappedException;
            }
            LOGGER.info("Mapped exception being null.");
        }
        catch (Exception mapException) {
            LOGGER.error("Map fatal error failed. ", (Throwable)mapException);
        }
        return null;
    }

    public static DiagnosticsProviderJvmFatalErrorMapper getMapper() {
        return diagnosticsProviderJvmFatalErrorMapper;
    }

    public long getMapperExecutionCount() {
        return this.mapperExecutionCount.get();
    }
}

