/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.crypto.Mac;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MacPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(MacPool.class);
    final Mac macInstance;
    final ConcurrentLinkedQueue<Mac> pool;
    final AtomicBoolean isMacInstanceCloneable = new AtomicBoolean(true);
    final Supplier<Mac> macProvider;

    public MacPool(Supplier<Mac> macProvider) {
        if (macProvider == null) {
            throw new IllegalArgumentException("macProvider");
        }
        this.macProvider = macProvider;
        this.macInstance = macProvider.get();
        this.pool = new ConcurrentLinkedQueue();
    }

    public ReUsableMac take() {
        Mac cachedInstance = this.pool.poll();
        if (cachedInstance == null) {
            cachedInstance = this.createNewMac();
        }
        return new ReUsableMac(cachedInstance, this);
    }

    private Mac createNewMac() {
        if (!this.isMacInstanceCloneable.get()) {
            return this.macProvider.get();
        }
        try {
            return (Mac)this.macInstance.clone();
        }
        catch (CloneNotSupportedException e) {
            LOGGER.warn("Cloning for the {} algorithm with provider {} ({}) not possible - this will result in less than ideal performance.", new Object[]{this.macInstance.getAlgorithm(), this.macInstance.getProvider().toString(), this.macInstance.getProvider().getInfo()});
            this.isMacInstanceCloneable.set(false);
            return this.macProvider.get();
        }
    }

    public void give(ReUsableMac closableMac) {
        this.pool.add(closableMac.macInstance);
    }

    static class ReUsableMac {
        final Mac macInstance;
        final MacPool pool;

        public ReUsableMac(Mac macInstance, MacPool pool) {
            this.macInstance = macInstance;
            this.pool = pool;
        }

        public Mac get() {
            return this.macInstance;
        }

        public void close() {
            this.pool.give(this);
        }
    }
}

