/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity.rntbd;

import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdChannelAcquisitionEventType;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;

@JsonSerialize(using=RntbdChannelAcquisitionEventJsonSerializer.class)
public class RntbdChannelAcquisitionEvent {
    private final Instant createdTime;
    private final RntbdChannelAcquisitionEventType eventType;
    private volatile Instant completeTime;

    public RntbdChannelAcquisitionEvent(RntbdChannelAcquisitionEventType eventType, Instant createdTime) {
        this.eventType = eventType;
        this.createdTime = createdTime;
    }

    public Instant getCreatedTime() {
        return this.createdTime;
    }

    public RntbdChannelAcquisitionEventType getEventType() {
        return this.eventType;
    }

    public Instant getCompleteTime() {
        return this.completeTime;
    }

    public void setCompleteTime(Instant completeTime) {
        this.completeTime = completeTime;
    }

    public void complete(Instant completeTime) {
        this.completeTime = completeTime;
    }

    public void addDetail(Object detail) {
    }

    public static void addDetail(RntbdChannelAcquisitionEvent event, Object detail) {
        if (event != null) {
            event.addDetail(detail);
        }
    }

    public Duration getDuration() {
        if (this.completeTime == null) {
            return null;
        }
        return Duration.between(this.createdTime, this.completeTime);
    }

    public static class RntbdChannelAcquisitionEventJsonSerializer
    extends JsonSerializer<RntbdChannelAcquisitionEvent> {
        public void serialize(RntbdChannelAcquisitionEvent event, JsonGenerator writer, SerializerProvider serializerProvider) throws IOException {
            writer.writeStartObject();
            writer.writeStringField(event.eventType.toString(), event.createdTime.toString());
            if (event.completeTime != null) {
                writer.writeNumberField("durationInMilliSecs", (double)event.getDuration().toNanos() / 1000000.0);
            }
            writer.writeEndObject();
        }
    }
}

