/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query.hybridsearch;

import com.azure.cosmos.implementation.Document;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;

public class HybridSearchQueryResult<T>
extends Document {
    public String rid = super.getResourceId();
    public List<Double> componentScores;
    public Document payload;
    public Double score;

    public HybridSearchQueryResult(String jsonString) {
        super(jsonString);
        Object outerObject = super.get("payload");
        if (outerObject instanceof ObjectNode) {
            JsonNode innerPayloadNode;
            ObjectNode outerObjectNode = (ObjectNode)outerObject;
            JsonNode componentScoresNode = outerObjectNode.get("componentScores");
            if (componentScoresNode != null && componentScoresNode.isArray()) {
                this.componentScores = new ArrayList<Double>();
                for (JsonNode scoreNode : componentScoresNode) {
                    if (scoreNode == null || !scoreNode.isNumber()) continue;
                    this.componentScores.add(scoreNode.asDouble());
                }
            }
            if ((innerPayloadNode = outerObjectNode.get("payload")) != null && innerPayloadNode.isObject()) {
                this.payload = new Document(innerPayloadNode.toString());
            }
        }
    }

    public String getRid() {
        return this.rid;
    }

    public void setRid(String rid) {
        super.setResourceId(rid);
    }

    public List<Double> getComponentScores() {
        return this.componentScores;
    }

    public void setComponentScores(List<Double> componentScores) {
        this.componentScores = componentScores;
    }

    public Document getPayload() {
        return this.payload;
    }

    public void setPayload(Document payload) {
        this.payload = payload;
    }

    public Double getScore() {
        return this.score;
    }

    public void setScore(Double score) {
        this.score = score;
    }
}

