/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.util.CoreUtils;
import com.azure.identity.CredentialUnavailableException;
import com.azure.identity.DeviceCodeInfo;
import com.azure.identity.implementation.CustomClaimRequest;
import com.azure.identity.implementation.IdentityClientBase;
import com.azure.identity.implementation.IdentityClientOptions;
import com.azure.identity.implementation.MsalToken;
import com.azure.identity.implementation.SynchronousAccessor;
import com.azure.identity.implementation.util.IdentityUtil;
import com.azure.identity.implementation.util.LoggingUtil;
import com.azure.identity.implementation.util.ScopeUtil;
import com.azure.identity.implementation.util.ValidationUtil;
import com.microsoft.aad.msal4j.AppTokenProviderParameters;
import com.microsoft.aad.msal4j.ClaimsRequest;
import com.microsoft.aad.msal4j.ClientCredentialFactory;
import com.microsoft.aad.msal4j.ClientCredentialParameters;
import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.DeviceCodeFlowParameters;
import com.microsoft.aad.msal4j.IAccount;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.IClientCredential;
import com.microsoft.aad.msal4j.InteractiveRequestParameters;
import com.microsoft.aad.msal4j.PublicClientApplication;
import com.microsoft.aad.msal4j.SilentParameters;
import com.microsoft.aad.msal4j.TokenProviderResult;
import com.microsoft.aad.msal4j.UserNamePasswordParameters;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;

public class IdentitySyncClient
extends IdentityClientBase {
    private final SynchronousAccessor<PublicClientApplication> publicClientApplicationAccessor = new SynchronousAccessor<PublicClientApplication>(() -> this.getPublicClient(isSharedTokenCacheCredential, false));
    private final SynchronousAccessor<PublicClientApplication> publicClientApplicationAccessorWithCae = new SynchronousAccessor<PublicClientApplication>(() -> this.getPublicClient(isSharedTokenCacheCredential, true));
    private final SynchronousAccessor<ConfidentialClientApplication> confidentialClientApplicationAccessor = new SynchronousAccessor<ConfidentialClientApplication>(() -> this.getConfidentialClient(false));
    private final SynchronousAccessor<ConfidentialClientApplication> confidentialClientApplicationAccessorWithCae = new SynchronousAccessor<ConfidentialClientApplication>(() -> this.getConfidentialClient(true));
    private final SynchronousAccessor<ConfidentialClientApplication> managedIdentityConfidentialClientApplicationAccessor = new SynchronousAccessor<ConfidentialClientApplication>(() -> this.getManagedIdentityConfidentialClient());
    private final SynchronousAccessor<ConfidentialClientApplication> workloadIdentityConfidentialClientApplicationAccessor = new SynchronousAccessor<ConfidentialClientApplication>(() -> this.getWorkloadIdentityConfidentialClient());
    private final SynchronousAccessor<String> clientAssertionAccessor;

    IdentitySyncClient(String tenantId, String clientId, String clientSecret, String certificatePath, String clientAssertionFilePath, String resourceId, Supplier<String> clientAssertionSupplier, byte[] certificate, String certificatePassword, boolean isSharedTokenCacheCredential, Duration clientAssertionTimeout, IdentityClientOptions options) {
        super(tenantId, clientId, clientSecret, certificatePath, clientAssertionFilePath, resourceId, clientAssertionSupplier, certificate, certificatePassword, isSharedTokenCacheCredential, clientAssertionTimeout, options);
        this.clientAssertionAccessor = clientAssertionTimeout == null ? new SynchronousAccessor<String>(() -> this.parseClientAssertion(), Duration.ofMinutes(5L)) : new SynchronousAccessor<String>(() -> this.parseClientAssertion(), clientAssertionTimeout);
    }

    private String parseClientAssertion() {
        if (this.clientAssertionFilePath != null) {
            try {
                byte[] encoded = Files.readAllBytes(Paths.get(this.clientAssertionFilePath, new String[0]));
                return new String(encoded, StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw LOGGER.logExceptionAsError(new RuntimeException(e));
            }
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Client Assertion File Path is not provided. It should be provided to authenticate with client assertion."));
    }

    public AccessToken authenticateWithConfidentialClient(TokenRequestContext request) {
        ConfidentialClientApplication confidentialClient = this.getConfidentialClientInstance(request).getValue();
        ClientCredentialParameters.ClientCredentialParametersBuilder builder = ClientCredentialParameters.builder(new HashSet(request.getScopes())).tenant(IdentityUtil.resolveTenantId(this.tenantId, request, this.options));
        if (this.clientAssertionSupplier != null) {
            builder.clientCredential((IClientCredential)ClientCredentialFactory.createFromClientAssertion((String)((String)this.clientAssertionSupplier.get())));
        }
        try {
            return new MsalToken((IAuthenticationResult)confidentialClient.acquireToken(builder.build()).get());
        }
        catch (InterruptedException | ExecutionException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
    }

    private SynchronousAccessor<ConfidentialClientApplication> getConfidentialClientInstance(TokenRequestContext request) {
        return request.isCaeEnabled() ? this.confidentialClientApplicationAccessorWithCae : this.confidentialClientApplicationAccessor;
    }

    private SynchronousAccessor<PublicClientApplication> getPublicClientInstance(TokenRequestContext request) {
        return request.isCaeEnabled() ? this.publicClientApplicationAccessorWithCae : this.publicClientApplicationAccessor;
    }

    public AccessToken authenticateWithManagedIdentityConfidentialClient(TokenRequestContext request) {
        ConfidentialClientApplication confidentialClient = this.managedIdentityConfidentialClientApplicationAccessor.getValue();
        ClientCredentialParameters.ClientCredentialParametersBuilder builder = ClientCredentialParameters.builder(new HashSet(request.getScopes())).tenant(IdentityUtil.resolveTenantId(this.tenantId, request, this.options));
        try {
            return new MsalToken((IAuthenticationResult)confidentialClient.acquireToken(builder.build()).get());
        }
        catch (Exception e) {
            throw new CredentialUnavailableException("Managed Identity authentication is not available.", e);
        }
    }

    public AccessToken authenticateWithConfidentialClientCache(TokenRequestContext request) {
        ConfidentialClientApplication confidentialClientApplication = this.getConfidentialClientInstance(request).getValue();
        SilentParameters.SilentParametersBuilder parametersBuilder = SilentParameters.builder(new HashSet(request.getScopes())).tenant(IdentityUtil.resolveTenantId(this.tenantId, request, this.options));
        if (request.isCaeEnabled() && request.getClaims() != null) {
            ClaimsRequest customClaimRequest = CustomClaimRequest.formatAsClaimsRequest(request.getClaims());
            parametersBuilder.claims(customClaimRequest);
            parametersBuilder.forceRefresh(true);
        }
        try {
            IAuthenticationResult authenticationResult = (IAuthenticationResult)confidentialClientApplication.acquireTokenSilently(parametersBuilder.build()).get();
            MsalToken accessToken = new MsalToken(authenticationResult);
            if (OffsetDateTime.now().isBefore(accessToken.getExpiresAt().minus(REFRESH_OFFSET))) {
                return accessToken;
            }
            throw new IllegalStateException("Received token is close to expiry.");
        }
        catch (MalformedURLException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(e.getMessage(), e));
        }
        catch (InterruptedException | ExecutionException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new ClientAuthenticationException(e.getMessage(), null, (Throwable)e));
        }
    }

    public MsalToken authenticateWithPublicClientCache(TokenRequestContext request, IAccount account) {
        PublicClientApplication pc = this.getPublicClientInstance(request).getValue();
        SilentParameters.SilentParametersBuilder parametersBuilder = SilentParameters.builder(new HashSet(request.getScopes()));
        if (request.getClaims() != null) {
            ClaimsRequest customClaimRequest = CustomClaimRequest.formatAsClaimsRequest(request.getClaims());
            parametersBuilder.claims(customClaimRequest);
            parametersBuilder.forceRefresh(true);
        }
        if (account != null) {
            parametersBuilder = parametersBuilder.account(account);
        }
        parametersBuilder.tenant(IdentityUtil.resolveTenantId(this.tenantId, request, this.options));
        try {
            MsalToken accessToken = new MsalToken((IAuthenticationResult)pc.acquireTokenSilently(parametersBuilder.build()).get());
            if (OffsetDateTime.now().isBefore(accessToken.getExpiresAt().minus(REFRESH_OFFSET))) {
                return accessToken;
            }
        }
        catch (MalformedURLException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(e.getMessage(), e));
        }
        catch (InterruptedException | ExecutionException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new ClientAuthenticationException(e.getMessage(), null, (Throwable)e));
        }
        SilentParameters.SilentParametersBuilder forceParametersBuilder = SilentParameters.builder(new HashSet(request.getScopes())).forceRefresh(true);
        if (request.isCaeEnabled() && request.getClaims() != null) {
            ClaimsRequest customClaimRequest = CustomClaimRequest.formatAsClaimsRequest(request.getClaims());
            forceParametersBuilder.claims(customClaimRequest);
        }
        if (account != null) {
            forceParametersBuilder = forceParametersBuilder.account(account);
        }
        forceParametersBuilder.tenant(IdentityUtil.resolveTenantId(this.tenantId, request, this.options));
        try {
            return new MsalToken((IAuthenticationResult)pc.acquireTokenSilently(forceParametersBuilder.build()).get());
        }
        catch (MalformedURLException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(e.getMessage(), e));
        }
        catch (InterruptedException | ExecutionException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new ClientAuthenticationException(e.getMessage(), null, (Throwable)e));
        }
    }

    public MsalToken authenticateWithUsernamePassword(TokenRequestContext request, String username, String password) {
        PublicClientApplication pc = this.getPublicClientInstance(request).getValue();
        UserNamePasswordParameters.UserNamePasswordParametersBuilder userNamePasswordParametersBuilder = this.buildUsernamePasswordFlowParameters(request, username, password);
        try {
            return new MsalToken((IAuthenticationResult)pc.acquireToken(userNamePasswordParametersBuilder.build()).get());
        }
        catch (Exception e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new ClientAuthenticationException("Failed to acquire token with username and password. To mitigate this issue, please refer to the troubleshooting guidelines here at https://aka.ms/azsdk/java/identity/usernamepasswordcredential/troubleshoot", null, (Throwable)e));
        }
    }

    public MsalToken authenticateWithDeviceCode(TokenRequestContext request, Consumer<DeviceCodeInfo> deviceCodeConsumer) {
        PublicClientApplication pc = this.getPublicClientInstance(request).getValue();
        DeviceCodeFlowParameters.DeviceCodeFlowParametersBuilder parametersBuilder = this.buildDeviceCodeFlowParameters(request, deviceCodeConsumer);
        try {
            return new MsalToken((IAuthenticationResult)pc.acquireToken(parametersBuilder.build()).get());
        }
        catch (Exception e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new ClientAuthenticationException("Failed to acquire token with device code.", null, (Throwable)e));
        }
    }

    public MsalToken authenticateWithBrowserInteraction(TokenRequestContext request, Integer port, String redirectUrl, String loginHint) {
        URI redirectUri;
        String redirect = port != null ? "http://localhost:" + port : (redirectUrl != null ? redirectUrl : "http://localhost");
        try {
            redirectUri = new URI(redirect);
        }
        catch (URISyntaxException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
        InteractiveRequestParameters.InteractiveRequestParametersBuilder builder = this.buildInteractiveRequestParameters(request, loginHint, redirectUri);
        PublicClientApplication pc = this.getPublicClientInstance(request).getValue();
        try {
            return new MsalToken((IAuthenticationResult)pc.acquireToken(builder.build()).get());
        }
        catch (Exception e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new ClientAuthenticationException("Failed to acquire token with Interactive Browser Authentication.", null, (Throwable)e));
        }
    }

    public AccessToken authenticateWithAzureCli(TokenRequestContext request) {
        StringBuilder azCommand = new StringBuilder("az account get-access-token --output json --resource ");
        String scopes = ScopeUtil.scopesToResource(request.getScopes());
        try {
            ScopeUtil.validateScope(scopes);
        }
        catch (IllegalArgumentException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)ex);
        }
        azCommand.append(scopes);
        String tenant = IdentityUtil.resolveTenantId(this.tenantId, request, this.options);
        ValidationUtil.validateTenantIdCharacterRange(tenant, LOGGER);
        if (!CoreUtils.isNullOrEmpty((CharSequence)tenant) && !tenant.equals("organizations")) {
            azCommand.append(" --tenant ").append(tenant);
        }
        try {
            return this.getTokenFromAzureCLIAuthentication(azCommand);
        }
        catch (RuntimeException e) {
            throw e instanceof CredentialUnavailableException ? LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, (CredentialUnavailableException)((Object)e)) : LOGGER.logExceptionAsError(e);
        }
    }

    public AccessToken authenticateWithAzureDeveloperCli(TokenRequestContext request) {
        StringBuilder azdCommand = new StringBuilder("azd auth token --output json --scope ");
        List scopes = request.getScopes();
        if (scopes.size() == 0) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing scope in request"));
        }
        scopes.forEach(scope -> {
            try {
                ScopeUtil.validateScope(scope);
            }
            catch (IllegalArgumentException ex) {
                throw LOGGER.logExceptionAsError((RuntimeException)ex);
            }
        });
        azdCommand.append(String.join((CharSequence)" --scope ", scopes));
        String tenant = IdentityUtil.resolveTenantId(this.tenantId, request, this.options);
        ValidationUtil.validateTenantIdCharacterRange(tenant, LOGGER);
        if (!CoreUtils.isNullOrEmpty((CharSequence)tenant) && !tenant.equals("organizations")) {
            azdCommand.append(" --tenant-id ").append(tenant);
        }
        try {
            return this.getTokenFromAzureDeveloperCLIAuthentication(azdCommand);
        }
        catch (RuntimeException e) {
            throw e instanceof CredentialUnavailableException ? LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, (CredentialUnavailableException)((Object)e)) : LOGGER.logExceptionAsError(e);
        }
    }

    public AccessToken authenticateWithOBO(TokenRequestContext request) {
        ConfidentialClientApplication cc = this.getConfidentialClientInstance(request).getValue();
        try {
            return new MsalToken((IAuthenticationResult)cc.acquireToken(this.buildOBOFlowParameters(request)).get());
        }
        catch (Exception e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new ClientAuthenticationException("Failed to acquire token with On Behalf Of Authentication.", null, (Throwable)e));
        }
    }

    public AccessToken authenticateWithExchangeTokenSync(TokenRequestContext request) {
        try {
            String assertionToken = this.clientAssertionAccessor.getValue();
            return this.authenticateWithExchangeTokenHelper(request, assertionToken);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    Function<AppTokenProviderParameters, CompletableFuture<TokenProviderResult>> getWorkloadIdentityTokenProvider() {
        return appTokenProviderParameters -> {
            TokenRequestContext trc = new TokenRequestContext().setScopes(new ArrayList(appTokenProviderParameters.scopes)).setClaims(appTokenProviderParameters.claims).setTenantId(appTokenProviderParameters.tenantId);
            AccessToken accessToken = this.authenticateWithExchangeTokenSync(trc);
            Supplier<TokenProviderResult> tokenProviderResultSupplier = () -> {
                TokenProviderResult result = new TokenProviderResult();
                result.setAccessToken(accessToken.getToken());
                result.setTenantId(trc.getTenantId());
                result.setExpiresInSeconds(accessToken.getExpiresAt().toEpochSecond());
                return result;
            };
            return this.options.getExecutorService() != null ? CompletableFuture.supplyAsync(tokenProviderResultSupplier, this.options.getExecutorService()) : CompletableFuture.supplyAsync(tokenProviderResultSupplier);
        };
    }

    public AccessToken authenticateWithWorkloadIdentityConfidentialClient(TokenRequestContext request) {
        ConfidentialClientApplication confidentialClient = this.workloadIdentityConfidentialClientApplicationAccessor.getValue();
        try {
            ClientCredentialParameters.ClientCredentialParametersBuilder builder = ClientCredentialParameters.builder(new HashSet(request.getScopes())).tenant(IdentityUtil.resolveTenantId(this.tenantId, request, this.options));
            return new MsalToken((IAuthenticationResult)confidentialClient.acquireToken(builder.build()).get());
        }
        catch (Exception e) {
            throw new CredentialUnavailableException("Managed Identity authentication is not available.", e);
        }
    }

    public IdentityClientOptions getIdentityClientOptions() {
        return this.options;
    }

    @Override
    Mono<AccessToken> getTokenFromTargetManagedIdentity(TokenRequestContext tokenRequestContext) {
        return null;
    }
}

