/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.AcsChatThreadEventBaseProperties;
import com.azure.messaging.eventgrid.systemevents.AcsChatThreadParticipantProperties;
import com.azure.messaging.eventgrid.systemevents.CommunicationIdentifierModel;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class AcsChatParticipantRemovedFromThreadWithUserEventData
extends AcsChatThreadEventBaseProperties {
    private OffsetDateTime time;
    private CommunicationIdentifierModel removedByCommunicationIdentifier;
    private AcsChatThreadParticipantProperties participantRemoved;

    public OffsetDateTime getTime() {
        return this.time;
    }

    public AcsChatParticipantRemovedFromThreadWithUserEventData setTime(OffsetDateTime time) {
        this.time = time;
        return this;
    }

    public CommunicationIdentifierModel getRemovedByCommunicationIdentifier() {
        return this.removedByCommunicationIdentifier;
    }

    public AcsChatParticipantRemovedFromThreadWithUserEventData setRemovedByCommunicationIdentifier(CommunicationIdentifierModel removedByCommunicationIdentifier) {
        this.removedByCommunicationIdentifier = removedByCommunicationIdentifier;
        return this;
    }

    public AcsChatThreadParticipantProperties getParticipantRemoved() {
        return this.participantRemoved;
    }

    public AcsChatParticipantRemovedFromThreadWithUserEventData setParticipantRemoved(AcsChatThreadParticipantProperties participantRemoved) {
        this.participantRemoved = participantRemoved;
        return this;
    }

    @Override
    public AcsChatParticipantRemovedFromThreadWithUserEventData setCreateTime(OffsetDateTime createTime) {
        super.setCreateTime(createTime);
        return this;
    }

    @Override
    public AcsChatParticipantRemovedFromThreadWithUserEventData setVersion(Long version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public AcsChatParticipantRemovedFromThreadWithUserEventData setRecipientCommunicationIdentifier(CommunicationIdentifierModel recipientCommunicationIdentifier) {
        super.setRecipientCommunicationIdentifier(recipientCommunicationIdentifier);
        return this;
    }

    @Override
    public AcsChatParticipantRemovedFromThreadWithUserEventData setTransactionId(String transactionId) {
        super.setTransactionId(transactionId);
        return this;
    }

    @Override
    public AcsChatParticipantRemovedFromThreadWithUserEventData setThreadId(String threadId) {
        super.setThreadId(threadId);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("recipientCommunicationIdentifier", (JsonSerializable)this.getRecipientCommunicationIdentifier());
        jsonWriter.writeStringField("transactionId", this.getTransactionId());
        jsonWriter.writeStringField("threadId", this.getThreadId());
        jsonWriter.writeStringField("createTime", this.getCreateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.getCreateTime()));
        jsonWriter.writeNumberField("version", (Number)this.getVersion());
        jsonWriter.writeStringField("time", this.time == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.time));
        jsonWriter.writeJsonField("removedByCommunicationIdentifier", (JsonSerializable)this.removedByCommunicationIdentifier);
        jsonWriter.writeJsonField("participantRemoved", (JsonSerializable)this.participantRemoved);
        return jsonWriter.writeEndObject();
    }

    public static AcsChatParticipantRemovedFromThreadWithUserEventData fromJson(JsonReader jsonReader) throws IOException {
        return (AcsChatParticipantRemovedFromThreadWithUserEventData)jsonReader.readObject(reader -> {
            AcsChatParticipantRemovedFromThreadWithUserEventData deserializedAcsChatParticipantRemovedFromThreadWithUserEventData = new AcsChatParticipantRemovedFromThreadWithUserEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("recipientCommunicationIdentifier".equals(fieldName)) {
                    deserializedAcsChatParticipantRemovedFromThreadWithUserEventData.setRecipientCommunicationIdentifier(CommunicationIdentifierModel.fromJson(reader));
                    continue;
                }
                if ("transactionId".equals(fieldName)) {
                    deserializedAcsChatParticipantRemovedFromThreadWithUserEventData.setTransactionId(reader.getString());
                    continue;
                }
                if ("threadId".equals(fieldName)) {
                    deserializedAcsChatParticipantRemovedFromThreadWithUserEventData.setThreadId(reader.getString());
                    continue;
                }
                if ("createTime".equals(fieldName)) {
                    deserializedAcsChatParticipantRemovedFromThreadWithUserEventData.setCreateTime((OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString())));
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedAcsChatParticipantRemovedFromThreadWithUserEventData.setVersion((Long)reader.getNullable(JsonReader::getLong));
                    continue;
                }
                if ("time".equals(fieldName)) {
                    deserializedAcsChatParticipantRemovedFromThreadWithUserEventData.time = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                if ("removedByCommunicationIdentifier".equals(fieldName)) {
                    deserializedAcsChatParticipantRemovedFromThreadWithUserEventData.removedByCommunicationIdentifier = CommunicationIdentifierModel.fromJson(reader);
                    continue;
                }
                if ("participantRemoved".equals(fieldName)) {
                    deserializedAcsChatParticipantRemovedFromThreadWithUserEventData.participantRemoved = AcsChatThreadParticipantProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAcsChatParticipantRemovedFromThreadWithUserEventData;
        });
    }
}

