/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.AcsRouterJobEventData;
import com.azure.messaging.eventgrid.systemevents.AcsRouterQueueDetails;
import com.azure.messaging.eventgrid.systemevents.AcsRouterWorkerSelector;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class AcsRouterJobClassifiedEventData
extends AcsRouterJobEventData {
    private AcsRouterQueueDetails queueDetails;
    private String classificationPolicyId;
    private Integer priority;
    private List<AcsRouterWorkerSelector> attachedWorkerSelectors;

    public AcsRouterQueueDetails getQueueDetails() {
        return this.queueDetails;
    }

    public AcsRouterJobClassifiedEventData setQueueDetails(AcsRouterQueueDetails queueDetails) {
        this.queueDetails = queueDetails;
        return this;
    }

    public String getClassificationPolicyId() {
        return this.classificationPolicyId;
    }

    public AcsRouterJobClassifiedEventData setClassificationPolicyId(String classificationPolicyId) {
        this.classificationPolicyId = classificationPolicyId;
        return this;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public AcsRouterJobClassifiedEventData setPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public List<AcsRouterWorkerSelector> getAttachedWorkerSelectors() {
        return this.attachedWorkerSelectors;
    }

    public AcsRouterJobClassifiedEventData setAttachedWorkerSelectors(List<AcsRouterWorkerSelector> attachedWorkerSelectors) {
        this.attachedWorkerSelectors = attachedWorkerSelectors;
        return this;
    }

    @Override
    public AcsRouterJobClassifiedEventData setQueueId(String queueId) {
        super.setQueueId(queueId);
        return this;
    }

    @Override
    public AcsRouterJobClassifiedEventData setLabels(Map<String, String> labels) {
        super.setLabels(labels);
        return this;
    }

    @Override
    public AcsRouterJobClassifiedEventData setTags(Map<String, String> tags) {
        super.setTags(tags);
        return this;
    }

    @Override
    public AcsRouterJobClassifiedEventData setJobId(String jobId) {
        super.setJobId(jobId);
        return this;
    }

    @Override
    public AcsRouterJobClassifiedEventData setChannelReference(String channelReference) {
        super.setChannelReference(channelReference);
        return this;
    }

    @Override
    public AcsRouterJobClassifiedEventData setChannelId(String channelId) {
        super.setChannelId(channelId);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("jobId", this.getJobId());
        jsonWriter.writeStringField("channelReference", this.getChannelReference());
        jsonWriter.writeStringField("channelId", this.getChannelId());
        jsonWriter.writeStringField("queueId", this.getQueueId());
        jsonWriter.writeMapField("labels", this.getLabels(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("tags", this.getTags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("queueDetails", (JsonSerializable)this.queueDetails);
        jsonWriter.writeStringField("classificationPolicyId", this.classificationPolicyId);
        jsonWriter.writeNumberField("priority", (Number)this.priority);
        jsonWriter.writeArrayField("attachedWorkerSelectors", this.attachedWorkerSelectors, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static AcsRouterJobClassifiedEventData fromJson(JsonReader jsonReader) throws IOException {
        return (AcsRouterJobClassifiedEventData)jsonReader.readObject(reader -> {
            AcsRouterJobClassifiedEventData deserializedAcsRouterJobClassifiedEventData = new AcsRouterJobClassifiedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("jobId".equals(fieldName)) {
                    deserializedAcsRouterJobClassifiedEventData.setJobId(reader.getString());
                    continue;
                }
                if ("channelReference".equals(fieldName)) {
                    deserializedAcsRouterJobClassifiedEventData.setChannelReference(reader.getString());
                    continue;
                }
                if ("channelId".equals(fieldName)) {
                    deserializedAcsRouterJobClassifiedEventData.setChannelId(reader.getString());
                    continue;
                }
                if ("queueId".equals(fieldName)) {
                    deserializedAcsRouterJobClassifiedEventData.setQueueId(reader.getString());
                    continue;
                }
                if ("labels".equals(fieldName)) {
                    Map labels = reader.readMap(reader1 -> reader1.getString());
                    deserializedAcsRouterJobClassifiedEventData.setLabels(labels);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedAcsRouterJobClassifiedEventData.setTags(tags);
                    continue;
                }
                if ("queueDetails".equals(fieldName)) {
                    deserializedAcsRouterJobClassifiedEventData.queueDetails = AcsRouterQueueDetails.fromJson(reader);
                    continue;
                }
                if ("classificationPolicyId".equals(fieldName)) {
                    deserializedAcsRouterJobClassifiedEventData.classificationPolicyId = reader.getString();
                    continue;
                }
                if ("priority".equals(fieldName)) {
                    deserializedAcsRouterJobClassifiedEventData.priority = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("attachedWorkerSelectors".equals(fieldName)) {
                    List attachedWorkerSelectors;
                    deserializedAcsRouterJobClassifiedEventData.attachedWorkerSelectors = attachedWorkerSelectors = reader.readArray(reader1 -> AcsRouterWorkerSelector.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAcsRouterJobClassifiedEventData;
        });
    }
}

