/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.AcsRouterJobEventData;
import com.azure.messaging.eventgrid.systemevents.AcsRouterWorkerSelector;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;

public final class AcsRouterJobWaitingForActivationEventData
extends AcsRouterJobEventData {
    private Integer priority;
    private List<AcsRouterWorkerSelector> expiredAttachedWorkerSelectors;
    private List<AcsRouterWorkerSelector> expiredRequestedWorkerSelectors;
    private OffsetDateTime scheduledOn;
    private boolean unavailableForMatching;

    public Integer getPriority() {
        return this.priority;
    }

    public AcsRouterJobWaitingForActivationEventData setPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public List<AcsRouterWorkerSelector> getExpiredAttachedWorkerSelectors() {
        return this.expiredAttachedWorkerSelectors;
    }

    public AcsRouterJobWaitingForActivationEventData setExpiredAttachedWorkerSelectors(List<AcsRouterWorkerSelector> expiredAttachedWorkerSelectors) {
        this.expiredAttachedWorkerSelectors = expiredAttachedWorkerSelectors;
        return this;
    }

    public List<AcsRouterWorkerSelector> getExpiredRequestedWorkerSelectors() {
        return this.expiredRequestedWorkerSelectors;
    }

    public AcsRouterJobWaitingForActivationEventData setExpiredRequestedWorkerSelectors(List<AcsRouterWorkerSelector> expiredRequestedWorkerSelectors) {
        this.expiredRequestedWorkerSelectors = expiredRequestedWorkerSelectors;
        return this;
    }

    public OffsetDateTime getScheduledOn() {
        return this.scheduledOn;
    }

    public AcsRouterJobWaitingForActivationEventData setScheduledOn(OffsetDateTime scheduledOn) {
        this.scheduledOn = scheduledOn;
        return this;
    }

    public Boolean isUnavailableForMatching() {
        return this.unavailableForMatching;
    }

    public AcsRouterJobWaitingForActivationEventData setUnavailableForMatching(Boolean unavailableForMatching) {
        this.unavailableForMatching = unavailableForMatching;
        return this;
    }

    @Override
    public AcsRouterJobWaitingForActivationEventData setQueueId(String queueId) {
        super.setQueueId(queueId);
        return this;
    }

    @Override
    public AcsRouterJobWaitingForActivationEventData setLabels(Map<String, String> labels) {
        super.setLabels(labels);
        return this;
    }

    @Override
    public AcsRouterJobWaitingForActivationEventData setTags(Map<String, String> tags) {
        super.setTags(tags);
        return this;
    }

    @Override
    public AcsRouterJobWaitingForActivationEventData setJobId(String jobId) {
        super.setJobId(jobId);
        return this;
    }

    @Override
    public AcsRouterJobWaitingForActivationEventData setChannelReference(String channelReference) {
        super.setChannelReference(channelReference);
        return this;
    }

    @Override
    public AcsRouterJobWaitingForActivationEventData setChannelId(String channelId) {
        super.setChannelId(channelId);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("jobId", this.getJobId());
        jsonWriter.writeStringField("channelReference", this.getChannelReference());
        jsonWriter.writeStringField("channelId", this.getChannelId());
        jsonWriter.writeStringField("queueId", this.getQueueId());
        jsonWriter.writeMapField("labels", this.getLabels(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("tags", this.getTags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("unavailableForMatching", this.unavailableForMatching);
        jsonWriter.writeNumberField("priority", (Number)this.priority);
        jsonWriter.writeArrayField("expiredAttachedWorkerSelectors", this.expiredAttachedWorkerSelectors, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("expiredRequestedWorkerSelectors", this.expiredRequestedWorkerSelectors, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("scheduledOn", this.scheduledOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.scheduledOn));
        return jsonWriter.writeEndObject();
    }

    public static AcsRouterJobWaitingForActivationEventData fromJson(JsonReader jsonReader) throws IOException {
        return (AcsRouterJobWaitingForActivationEventData)jsonReader.readObject(reader -> {
            AcsRouterJobWaitingForActivationEventData deserializedAcsRouterJobWaitingForActivationEventData = new AcsRouterJobWaitingForActivationEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("jobId".equals(fieldName)) {
                    deserializedAcsRouterJobWaitingForActivationEventData.setJobId(reader.getString());
                    continue;
                }
                if ("channelReference".equals(fieldName)) {
                    deserializedAcsRouterJobWaitingForActivationEventData.setChannelReference(reader.getString());
                    continue;
                }
                if ("channelId".equals(fieldName)) {
                    deserializedAcsRouterJobWaitingForActivationEventData.setChannelId(reader.getString());
                    continue;
                }
                if ("queueId".equals(fieldName)) {
                    deserializedAcsRouterJobWaitingForActivationEventData.setQueueId(reader.getString());
                    continue;
                }
                if ("labels".equals(fieldName)) {
                    Map labels = reader.readMap(reader1 -> reader1.getString());
                    deserializedAcsRouterJobWaitingForActivationEventData.setLabels(labels);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedAcsRouterJobWaitingForActivationEventData.setTags(tags);
                    continue;
                }
                if ("unavailableForMatching".equals(fieldName)) {
                    deserializedAcsRouterJobWaitingForActivationEventData.unavailableForMatching = reader.getBoolean();
                    continue;
                }
                if ("priority".equals(fieldName)) {
                    deserializedAcsRouterJobWaitingForActivationEventData.priority = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("expiredAttachedWorkerSelectors".equals(fieldName)) {
                    List expiredAttachedWorkerSelectors;
                    deserializedAcsRouterJobWaitingForActivationEventData.expiredAttachedWorkerSelectors = expiredAttachedWorkerSelectors = reader.readArray(reader1 -> AcsRouterWorkerSelector.fromJson(reader1));
                    continue;
                }
                if ("expiredRequestedWorkerSelectors".equals(fieldName)) {
                    List expiredRequestedWorkerSelectors;
                    deserializedAcsRouterJobWaitingForActivationEventData.expiredRequestedWorkerSelectors = expiredRequestedWorkerSelectors = reader.readArray(reader1 -> AcsRouterWorkerSelector.fromJson(reader1));
                    continue;
                }
                if ("scheduledOn".equals(fieldName)) {
                    deserializedAcsRouterJobWaitingForActivationEventData.scheduledOn = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAcsRouterJobWaitingForActivationEventData;
        });
    }
}

