/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class AcsSmsDeliveryAttemptProperties
implements JsonSerializable<AcsSmsDeliveryAttemptProperties> {
    private OffsetDateTime timestamp;
    private Integer segmentsSucceeded;
    private Integer segmentsFailed;

    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public AcsSmsDeliveryAttemptProperties setTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public Integer getSegmentsSucceeded() {
        return this.segmentsSucceeded;
    }

    public AcsSmsDeliveryAttemptProperties setSegmentsSucceeded(Integer segmentsSucceeded) {
        this.segmentsSucceeded = segmentsSucceeded;
        return this;
    }

    public Integer getSegmentsFailed() {
        return this.segmentsFailed;
    }

    public AcsSmsDeliveryAttemptProperties setSegmentsFailed(Integer segmentsFailed) {
        this.segmentsFailed = segmentsFailed;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("timestamp", this.timestamp == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.timestamp));
        jsonWriter.writeNumberField("segmentsSucceeded", (Number)this.segmentsSucceeded);
        jsonWriter.writeNumberField("segmentsFailed", (Number)this.segmentsFailed);
        return jsonWriter.writeEndObject();
    }

    public static AcsSmsDeliveryAttemptProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AcsSmsDeliveryAttemptProperties)jsonReader.readObject(reader -> {
            AcsSmsDeliveryAttemptProperties deserializedAcsSmsDeliveryAttemptProperties = new AcsSmsDeliveryAttemptProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("timestamp".equals(fieldName)) {
                    deserializedAcsSmsDeliveryAttemptProperties.timestamp = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                if ("segmentsSucceeded".equals(fieldName)) {
                    deserializedAcsSmsDeliveryAttemptProperties.segmentsSucceeded = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("segmentsFailed".equals(fieldName)) {
                    deserializedAcsSmsDeliveryAttemptProperties.segmentsFailed = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAcsSmsDeliveryAttemptProperties;
        });
    }
}

