/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.DeviceConnectionStateEventInfo;
import com.azure.messaging.eventgrid.systemevents.DeviceConnectionStateEventProperties;
import java.io.IOException;

public final class IotHubDeviceConnectedEventData
extends DeviceConnectionStateEventProperties {
    @Override
    public IotHubDeviceConnectedEventData setDeviceId(String deviceId) {
        super.setDeviceId(deviceId);
        return this;
    }

    @Override
    public IotHubDeviceConnectedEventData setModuleId(String moduleId) {
        super.setModuleId(moduleId);
        return this;
    }

    @Override
    public IotHubDeviceConnectedEventData setHubName(String hubName) {
        super.setHubName(hubName);
        return this;
    }

    @Override
    public IotHubDeviceConnectedEventData setDeviceConnectionStateEventInfo(DeviceConnectionStateEventInfo deviceConnectionStateEventInfo) {
        super.setDeviceConnectionStateEventInfo(deviceConnectionStateEventInfo);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("deviceId", this.getDeviceId());
        jsonWriter.writeStringField("moduleId", this.getModuleId());
        jsonWriter.writeStringField("hubName", this.getHubName());
        jsonWriter.writeJsonField("deviceConnectionStateEventInfo", (JsonSerializable)this.getDeviceConnectionStateEventInfo());
        return jsonWriter.writeEndObject();
    }

    public static IotHubDeviceConnectedEventData fromJson(JsonReader jsonReader) throws IOException {
        return (IotHubDeviceConnectedEventData)jsonReader.readObject(reader -> {
            IotHubDeviceConnectedEventData deserializedIotHubDeviceConnectedEventData = new IotHubDeviceConnectedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("deviceId".equals(fieldName)) {
                    deserializedIotHubDeviceConnectedEventData.setDeviceId(reader.getString());
                    continue;
                }
                if ("moduleId".equals(fieldName)) {
                    deserializedIotHubDeviceConnectedEventData.setModuleId(reader.getString());
                    continue;
                }
                if ("hubName".equals(fieldName)) {
                    deserializedIotHubDeviceConnectedEventData.setHubName(reader.getString());
                    continue;
                }
                if ("deviceConnectionStateEventInfo".equals(fieldName)) {
                    deserializedIotHubDeviceConnectedEventData.setDeviceConnectionStateEventInfo(DeviceConnectionStateEventInfo.fromJson(reader));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIotHubDeviceConnectedEventData;
        });
    }
}

