/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.MediaJobOutput;
import com.azure.messaging.eventgrid.systemevents.MediaJobState;
import com.azure.messaging.eventgrid.systemevents.MediaJobStateChangeEventData;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class MediaJobErroredEventData
extends MediaJobStateChangeEventData {
    private List<MediaJobOutput> outputs;

    public List<MediaJobOutput> getOutputs() {
        return this.outputs;
    }

    public MediaJobErroredEventData setOutputs(List<MediaJobOutput> outputs) {
        this.outputs = outputs;
        return this;
    }

    @Override
    public MediaJobErroredEventData setCorrelationData(Map<String, String> correlationData) {
        super.setCorrelationData(correlationData);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("correlationData", this.getCorrelationData(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("outputs", this.outputs, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static MediaJobErroredEventData fromJson(JsonReader jsonReader) throws IOException {
        return (MediaJobErroredEventData)jsonReader.readObject(reader -> {
            MediaJobErroredEventData deserializedMediaJobErroredEventData = new MediaJobErroredEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("previousState".equals(fieldName)) {
                    deserializedMediaJobErroredEventData.setPreviousState(MediaJobState.fromString(reader.getString()));
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedMediaJobErroredEventData.setState(MediaJobState.fromString(reader.getString()));
                    continue;
                }
                if ("correlationData".equals(fieldName)) {
                    Map correlationData = reader.readMap(reader1 -> reader1.getString());
                    deserializedMediaJobErroredEventData.setCorrelationData(correlationData);
                    continue;
                }
                if ("outputs".equals(fieldName)) {
                    List outputs;
                    deserializedMediaJobErroredEventData.outputs = outputs = reader.readArray(reader1 -> MediaJobOutput.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMediaJobErroredEventData;
        });
    }
}

