/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.messaging.servicebus.administration.implementation.models.KeyValueImpl;
import com.azure.messaging.servicebus.administration.implementation.models.RuleActionImpl;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class SqlRuleActionImpl
extends RuleActionImpl {
    private static final String SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT = "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect";
    private static final String WWW_W3_ORG_TWO_ZERO_ZERO_ONE_XMLSCHEMA_INSTANCE = "http://www.w3.org/2001/XMLSchema-instance";
    private String sqlExpression;
    private String compatibilityLevel;
    private List<KeyValueImpl> parameters;
    private Boolean requiresPreprocessing;

    public String getSqlExpression() {
        return this.sqlExpression;
    }

    public SqlRuleActionImpl setSqlExpression(String sqlExpression) {
        this.sqlExpression = sqlExpression;
        return this;
    }

    public String getCompatibilityLevel() {
        return this.compatibilityLevel;
    }

    public SqlRuleActionImpl setCompatibilityLevel(String compatibilityLevel) {
        this.compatibilityLevel = compatibilityLevel;
        return this;
    }

    public List<KeyValueImpl> getParameters() {
        if (this.parameters == null) {
            this.parameters = new ArrayList<KeyValueImpl>();
        }
        return this.parameters;
    }

    public SqlRuleActionImpl setParameters(List<KeyValueImpl> parameters) {
        this.parameters = parameters;
        return this;
    }

    public Boolean isRequiresPreprocessing() {
        return this.requiresPreprocessing;
    }

    public SqlRuleActionImpl setRequiresPreprocessing(Boolean requiresPreprocessing) {
        this.requiresPreprocessing = requiresPreprocessing;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "Action" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeNamespace(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT);
        xmlWriter.writeNamespace("xsi", WWW_W3_ORG_TWO_ZERO_ZERO_ONE_XMLSCHEMA_INSTANCE);
        xmlWriter.writeStringAttribute(WWW_W3_ORG_TWO_ZERO_ZERO_ONE_XMLSCHEMA_INSTANCE, "type", "SqlRuleAction");
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "SqlExpression", this.sqlExpression);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "CompatibilityLevel", this.compatibilityLevel);
        if (this.parameters != null) {
            xmlWriter.writeStartElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "Parameters");
            for (KeyValueImpl element : this.parameters) {
                xmlWriter.writeXml((XmlSerializable)element, "KeyValueOfstringanyType");
            }
            xmlWriter.writeEndElement();
        }
        xmlWriter.writeBooleanElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "RequiresPreprocessing", this.requiresPreprocessing);
        return xmlWriter.writeEndElement();
    }

    public static SqlRuleActionImpl fromXml(XmlReader xmlReader) throws XMLStreamException {
        return SqlRuleActionImpl.fromXml(xmlReader, null);
    }

    public static SqlRuleActionImpl fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "Action" : rootElementName;
        return (SqlRuleActionImpl)xmlReader.readObject(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, finalRootElementName, reader -> {
            SqlRuleActionImpl deserializedSqlRuleAction = new SqlRuleActionImpl();
            String discriminatorValue = reader.getStringAttribute(WWW_W3_ORG_TWO_ZERO_ZERO_ONE_XMLSCHEMA_INSTANCE, "type");
            if (!"SqlRuleAction".equals(discriminatorValue)) {
                throw new IllegalStateException("'type' was expected to be non-null and equal to 'SqlRuleAction'. The found 'type' was '" + discriminatorValue + "'.");
            }
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("SqlExpression".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSqlRuleAction.sqlExpression = reader.getStringElement();
                    continue;
                }
                if ("CompatibilityLevel".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSqlRuleAction.compatibilityLevel = reader.getStringElement();
                    continue;
                }
                if ("Parameters".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    while (reader.nextElement() != XmlToken.END_ELEMENT) {
                        elementName = reader.getElementName();
                        if ("KeyValueOfstringanyType".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                            if (deserializedSqlRuleAction.parameters == null) {
                                deserializedSqlRuleAction.parameters = new ArrayList<KeyValueImpl>();
                            }
                            deserializedSqlRuleAction.parameters.add(KeyValueImpl.fromXml(reader, "KeyValueOfstringanyType"));
                            continue;
                        }
                        reader.skipElement();
                    }
                    continue;
                }
                if ("RequiresPreprocessing".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSqlRuleAction.requiresPreprocessing = (Boolean)reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                reader.skipElement();
            }
            return deserializedSqlRuleAction;
        });
    }
}

