/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.tracing.Tracer;
import com.azure.monitor.opentelemetry.exporter.AzureMonitorExporterServiceVersion;
import com.azure.monitor.opentelemetry.exporter.AzureMonitorLogRecordExporter;
import com.azure.monitor.opentelemetry.exporter.AzureMonitorMetricExporter;
import com.azure.monitor.opentelemetry.exporter.AzureMonitorTraceExporter;
import com.azure.monitor.opentelemetry.exporter.implementation.AzureMonitorLogRecordExporterProvider;
import com.azure.monitor.opentelemetry.exporter.implementation.AzureMonitorMetricExporterProvider;
import com.azure.monitor.opentelemetry.exporter.implementation.AzureMonitorSpanExporterProvider;
import com.azure.monitor.opentelemetry.exporter.implementation.LogDataMapper;
import com.azure.monitor.opentelemetry.exporter.implementation.MetricDataMapper;
import com.azure.monitor.opentelemetry.exporter.implementation.NoopTracer;
import com.azure.monitor.opentelemetry.exporter.implementation.SpanDataMapper;
import com.azure.monitor.opentelemetry.exporter.implementation.builders.AbstractTelemetryBuilder;
import com.azure.monitor.opentelemetry.exporter.implementation.configuration.ConnectionString;
import com.azure.monitor.opentelemetry.exporter.implementation.configuration.StatsbeatConnectionString;
import com.azure.monitor.opentelemetry.exporter.implementation.heartbeat.HeartbeatExporter;
import com.azure.monitor.opentelemetry.exporter.implementation.localstorage.LocalStorageStats;
import com.azure.monitor.opentelemetry.exporter.implementation.models.ContextTagKeys;
import com.azure.monitor.opentelemetry.exporter.implementation.pipeline.TelemetryItemExporter;
import com.azure.monitor.opentelemetry.exporter.implementation.statsbeat.Feature;
import com.azure.monitor.opentelemetry.exporter.implementation.statsbeat.StatsbeatModule;
import com.azure.monitor.opentelemetry.exporter.implementation.utils.AzureMonitorHelper;
import com.azure.monitor.opentelemetry.exporter.implementation.utils.PropertyHelper;
import com.azure.monitor.opentelemetry.exporter.implementation.utils.ResourceParser;
import com.azure.monitor.opentelemetry.exporter.implementation.utils.TempDirs;
import com.azure.monitor.opentelemetry.exporter.implementation.utils.VersionGenerator;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdkBuilder;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.internal.DefaultConfigProperties;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import io.opentelemetry.sdk.metrics.Aggregation;
import io.opentelemetry.sdk.metrics.InstrumentSelector;
import io.opentelemetry.sdk.metrics.View;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;

public final class AzureMonitorExporterBuilder {
    private static final ClientLogger LOGGER = new ClientLogger(AzureMonitorExporterBuilder.class);
    private static final String APPLICATIONINSIGHTS_CONNECTION_STRING = "APPLICATIONINSIGHTS_CONNECTION_STRING";
    private static final String APPLICATIONINSIGHTS_AUTHENTICATION_SCOPE = "https://monitor.azure.com//.default";
    private static final String STATSBEAT_LONG_INTERVAL_SECONDS_PROPERTY_NAME = "STATSBEAT_LONG_INTERVAL_SECONDS_PROPERTY_NAME";
    private static final String STATSBEAT_SHORT_INTERVAL_SECONDS_PROPERTY_NAME = "STATSBEAT_SHORT_INTERVAL_SECONDS_PROPERTY_NAME";
    private static final Map<String, String> PROPERTIES = CoreUtils.getProperties((String)"azure-monitor-opentelemetry-exporter.properties");
    private ConnectionString connectionString;
    private TokenCredential credential;
    private AzureMonitorExporterServiceVersion serviceVersion;
    private HttpPipeline httpPipeline;
    private HttpClient httpClient;
    private HttpLogOptions httpLogOptions;
    private final List<HttpPipelinePolicy> httpPipelinePolicies = new ArrayList<HttpPipelinePolicy>();
    private ClientOptions clientOptions;
    private boolean frozen;
    private TelemetryItemExporter builtTelemetryItemExporter;
    private StatsbeatModule statsbeatModule;

    public AzureMonitorExporterBuilder httpPipeline(HttpPipeline httpPipeline) {
        if (this.frozen) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("httpPipeline cannot be changed after any of the build methods have been called"));
        }
        this.httpPipeline = httpPipeline;
        return this;
    }

    public AzureMonitorExporterBuilder httpClient(HttpClient httpClient) {
        if (this.frozen) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("httpClient cannot be changed after any of the build methods have been called"));
        }
        this.httpClient = httpClient;
        return this;
    }

    public AzureMonitorExporterBuilder httpLogOptions(HttpLogOptions httpLogOptions) {
        if (this.frozen) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("httpLogOptions cannot be changed after any of the build methods have been called"));
        }
        this.httpLogOptions = httpLogOptions;
        return this;
    }

    public AzureMonitorExporterBuilder addHttpPipelinePolicy(HttpPipelinePolicy httpPipelinePolicy) {
        if (this.frozen) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("httpPipelinePolicies cannot be added after any of the build methods have been called"));
        }
        this.httpPipelinePolicies.add(Objects.requireNonNull(httpPipelinePolicy, "'policy' cannot be null."));
        return this;
    }

    public AzureMonitorExporterBuilder clientOptions(ClientOptions clientOptions) {
        if (this.frozen) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("clientOptions cannot be changed after any of the build methods have been called"));
        }
        this.clientOptions = clientOptions;
        return this;
    }

    public AzureMonitorExporterBuilder connectionString(String connectionString) {
        if (this.frozen) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("connectionString cannot be changed after any of the build methods have been called"));
        }
        this.connectionString = ConnectionString.parse(connectionString);
        return this;
    }

    public AzureMonitorExporterBuilder serviceVersion(AzureMonitorExporterServiceVersion serviceVersion) {
        if (this.frozen) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("serviceVersion cannot be changed after any of the build methods have been called"));
        }
        this.serviceVersion = serviceVersion;
        return this;
    }

    public AzureMonitorExporterBuilder credential(TokenCredential credential) {
        if (this.frozen) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("credential cannot be changed after any of the build methods have been called"));
        }
        this.credential = credential;
        return this;
    }

    public SpanExporter buildTraceExporter() {
        DefaultConfigProperties defaultConfig = DefaultConfigProperties.create(Collections.emptyMap());
        this.internalBuildAndFreeze((ConfigProperties)defaultConfig);
        return this.buildTraceExporter((ConfigProperties)defaultConfig);
    }

    public MetricExporter buildMetricExporter() {
        DefaultConfigProperties defaultConfig = DefaultConfigProperties.create(Collections.emptyMap());
        this.internalBuildAndFreeze((ConfigProperties)defaultConfig);
        return this.buildMetricExporter((ConfigProperties)defaultConfig);
    }

    public LogRecordExporter buildLogRecordExporter() {
        DefaultConfigProperties defaultConfig = DefaultConfigProperties.create(Collections.emptyMap());
        this.internalBuildAndFreeze((ConfigProperties)defaultConfig);
        return this.buildLogRecordExporter((ConfigProperties)defaultConfig);
    }

    public void install(AutoConfiguredOpenTelemetrySdkBuilder sdkBuilder) {
        sdkBuilder.addPropertiesSupplier(() -> {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("otel.traces.exporter", "azure_monitor");
            props.put("otel.metrics.exporter", "azure_monitor");
            props.put("otel.logs.exporter", "azure_monitor");
            props.put("_internal_using_azure_monitor_exporter_builder", "true");
            return props;
        });
        sdkBuilder.addSpanExporterCustomizer((spanExporter, configProperties) -> {
            if (spanExporter instanceof AzureMonitorSpanExporterProvider.MarkerSpanExporter) {
                this.internalBuildAndFreeze((ConfigProperties)configProperties);
                spanExporter = this.buildTraceExporter((ConfigProperties)configProperties);
            }
            return spanExporter;
        });
        sdkBuilder.addMetricExporterCustomizer((metricExporter, configProperties) -> {
            if (metricExporter instanceof AzureMonitorMetricExporterProvider.MarkerMetricExporter) {
                this.internalBuildAndFreeze((ConfigProperties)configProperties);
                metricExporter = this.buildMetricExporter((ConfigProperties)configProperties);
            }
            return metricExporter;
        });
        sdkBuilder.addLogRecordExporterCustomizer((logRecordExporter, configProperties) -> {
            if (logRecordExporter instanceof AzureMonitorLogRecordExporterProvider.MarkerLogRecordExporter) {
                this.internalBuildAndFreeze((ConfigProperties)configProperties);
                logRecordExporter = this.buildLogRecordExporter((ConfigProperties)configProperties);
            }
            return logRecordExporter;
        });
        sdkBuilder.addMeterProviderCustomizer((sdkMeterProviderBuilder, config) -> sdkMeterProviderBuilder.registerView(InstrumentSelector.builder().setMeterName("io.opentelemetry.sdk.trace").build(), View.builder().setAggregation(Aggregation.drop()).build()).registerView(InstrumentSelector.builder().setMeterName("io.opentelemetry.sdk.logs").build(), View.builder().setAggregation(Aggregation.drop()).build()));
    }

    private void internalBuildAndFreeze(ConfigProperties configProperties) {
        if (!this.frozen) {
            HttpPipeline httpPipeline = this.createHttpPipeline();
            this.statsbeatModule = this.initStatsbeatModule(configProperties);
            File tempDir = TempDirs.getApplicationInsightsTempDir(LOGGER, "Telemetry will not be stored to disk and retried on sporadic network failures");
            this.builtTelemetryItemExporter = AzureMonitorHelper.createTelemetryItemExporter(httpPipeline, this.statsbeatModule, tempDir, LocalStorageStats.noop());
            this.startStatsbeatModule(this.statsbeatModule, configProperties, tempDir);
            this.frozen = true;
        }
    }

    private SpanExporter buildTraceExporter(ConfigProperties configProperties) {
        return new AzureMonitorTraceExporter(this.createSpanDataMapper(configProperties), this.builtTelemetryItemExporter, this.statsbeatModule);
    }

    private MetricExporter buildMetricExporter(ConfigProperties configProperties) {
        HeartbeatExporter.start(TimeUnit.MINUTES.toSeconds(15L), this.createDefaultsPopulator(configProperties), this.builtTelemetryItemExporter::send);
        return new AzureMonitorMetricExporter(new MetricDataMapper(this.createDefaultsPopulator(configProperties), true), this.builtTelemetryItemExporter);
    }

    private Set<Feature> initStatsbeatFeatures() {
        if (System.getProperty("org.graalvm.nativeimage.imagecode") != null) {
            return Collections.singleton(Feature.GRAAL_VM_NATIVE);
        }
        return Collections.emptySet();
    }

    private StatsbeatConnectionString getStatsbeatConnectionString() {
        return StatsbeatConnectionString.create(this.connectionString, null, null);
    }

    private LogRecordExporter buildLogRecordExporter(ConfigProperties configProperties) {
        return new AzureMonitorLogRecordExporter(new LogDataMapper(true, false, this.createDefaultsPopulator(configProperties)), this.builtTelemetryItemExporter);
    }

    private SpanDataMapper createSpanDataMapper(ConfigProperties configProperties) {
        return new SpanDataMapper(true, this.createDefaultsPopulator(configProperties), (event, instrumentationName) -> false, (span, event) -> false);
    }

    private BiConsumer<AbstractTelemetryBuilder, Resource> createDefaultsPopulator(ConfigProperties configProperties) {
        ConnectionString connectionString = this.getConnectionString(configProperties);
        ResourceParser resourceParser = new ResourceParser();
        return (builder, resource) -> {
            builder.setConnectionString(connectionString);
            builder.setResource((Resource)resource);
            builder.addTag(ContextTagKeys.AI_INTERNAL_SDK_VERSION.toString(), VersionGenerator.getSdkVersion());
            resourceParser.updateRoleNameAndInstance((AbstractTelemetryBuilder)builder, (Resource)resource);
        };
    }

    private ConnectionString getConnectionString(ConfigProperties configProperties) {
        if (this.connectionString != null) {
            return this.connectionString;
        }
        ConnectionString connectionString = ConnectionString.parse(configProperties.getString(APPLICATIONINSIGHTS_CONNECTION_STRING));
        return Objects.requireNonNull(connectionString, "'connectionString' cannot be null");
    }

    private HttpPipeline createHttpPipeline() {
        if (this.httpPipeline != null) {
            if (this.credential != null) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'credential' is not supported when custom 'httpPipeline' is specified"));
            }
            if (this.httpClient != null) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'httpClient' is not supported when custom 'httpPipeline' is specified"));
            }
            if (this.httpLogOptions != null) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'httpLogOptions' is not supported when custom 'httpPipeline' is specified"));
            }
            if (!this.httpPipelinePolicies.isEmpty()) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'httpPipelinePolicies' is not supported when custom 'httpPipeline' is specified"));
            }
            if (this.clientOptions != null) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'clientOptions' is not supported when custom 'httpPipeline' is specified"));
            }
            return this.httpPipeline;
        }
        ArrayList<Object> policies = new ArrayList<Object>();
        String clientName = PROPERTIES.getOrDefault("name", "UnknownName");
        String clientVersion = PROPERTIES.getOrDefault("version", "UnknownVersion");
        String applicationId = CoreUtils.getApplicationId((ClientOptions)this.clientOptions, (HttpLogOptions)this.httpLogOptions);
        policies.add(new UserAgentPolicy(applicationId, clientName, clientVersion, Configuration.getGlobalConfiguration()));
        policies.add(new CookiePolicy());
        if (this.credential != null) {
            policies.add(new BearerTokenAuthenticationPolicy(this.credential, new String[]{APPLICATIONINSIGHTS_AUTHENTICATION_SCOPE}));
        }
        policies.addAll(this.httpPipelinePolicies);
        policies.add(new HttpLoggingPolicy(this.httpLogOptions));
        return new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(this.httpClient).tracer((Tracer)new NoopTracer()).build();
    }

    private StatsbeatModule initStatsbeatModule(ConfigProperties configProperties) {
        return new StatsbeatModule(PropertyHelper::lazyUpdateVmRpIntegration);
    }

    private void startStatsbeatModule(StatsbeatModule statsbeatModule, ConfigProperties configProperties, File tempDir) {
        HttpPipeline statsbeatHttpPipeline = this.createStatsbeatHttpPipeline();
        TelemetryItemExporter statsbeatTelemetryItemExporter = AzureMonitorHelper.createStatsbeatTelemetryItemExporter(statsbeatHttpPipeline, statsbeatModule, tempDir);
        statsbeatModule.start(statsbeatTelemetryItemExporter, this::getStatsbeatConnectionString, this.getConnectionString(configProperties)::getInstrumentationKey, false, configProperties.getLong(STATSBEAT_SHORT_INTERVAL_SECONDS_PROPERTY_NAME, TimeUnit.MINUTES.toSeconds(15L)), configProperties.getLong(STATSBEAT_LONG_INTERVAL_SECONDS_PROPERTY_NAME, TimeUnit.DAYS.toSeconds(1L)), false, this.initStatsbeatFeatures());
    }

    private HttpPipeline createStatsbeatHttpPipeline() {
        if (this.httpPipeline != null) {
            return this.httpPipeline;
        }
        ArrayList<Object> policies = new ArrayList<Object>();
        String clientName = PROPERTIES.getOrDefault("name", "UnknownName");
        String clientVersion = PROPERTIES.getOrDefault("version", "UnknownVersion");
        String applicationId = CoreUtils.getApplicationId((ClientOptions)this.clientOptions, (HttpLogOptions)this.httpLogOptions);
        policies.add(new UserAgentPolicy(applicationId, clientName, clientVersion, Configuration.getGlobalConfiguration()));
        policies.add(new CookiePolicy());
        policies.addAll(this.httpPipelinePolicies);
        policies.add(new HttpLoggingPolicy(this.httpLogOptions));
        return new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(this.httpClient).tracer((Tracer)new NoopTracer()).build();
    }
}

