/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.builders;

import com.azure.monitor.opentelemetry.exporter.implementation.builders.StackFrameBuilder;
import com.azure.monitor.opentelemetry.exporter.implementation.builders.TelemetryTruncation;
import com.azure.monitor.opentelemetry.exporter.implementation.models.StackFrame;
import com.azure.monitor.opentelemetry.exporter.implementation.models.TelemetryExceptionDetails;
import java.util.ArrayList;
import java.util.List;

public final class ExceptionDetailBuilder {
    private static final int MAX_NAME_LENGTH = 1024;
    private static final int MAX_MESSAGE_LENGTH = 32768;
    private final TelemetryExceptionDetails data = new TelemetryExceptionDetails();

    public void setId(Integer id) {
        this.data.setId(id);
    }

    public void setOuter(ExceptionDetailBuilder outer) {
        this.data.setOuterId(outer.data.getId());
    }

    public void setTypeName(String typeName) {
        this.data.setTypeName(TelemetryTruncation.truncateTelemetry(typeName, 1024, "ExceptionDetail.typeName"));
    }

    public void setMessage(String message) {
        this.data.setMessage(TelemetryTruncation.truncateTelemetry(message, 32768, "ExceptionDetail.message"));
    }

    public void setHasFullStack(Boolean hasFullStack) {
        this.data.setHasFullStack(hasFullStack);
    }

    public void setStack(String stack) {
        this.data.setStack(TelemetryTruncation.truncateTelemetry(stack, 32768, "ExceptionDetail.stack"));
    }

    public void setParsedStack(List<StackFrameBuilder> builders) {
        ArrayList<StackFrame> stackFrames = new ArrayList<StackFrame>();
        for (StackFrameBuilder builder : builders) {
            stackFrames.add(builder.build());
        }
        this.data.setParsedStack(stackFrames);
    }

    public TelemetryExceptionDetails build() {
        return this.data;
    }
}

