/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.builders;

import com.azure.monitor.opentelemetry.exporter.implementation.builders.AbstractTelemetryBuilder;
import com.azure.monitor.opentelemetry.exporter.implementation.builders.TelemetryTruncation;
import com.azure.monitor.opentelemetry.exporter.implementation.models.MessageData;
import com.azure.monitor.opentelemetry.exporter.implementation.models.SeverityLevel;
import java.util.HashMap;
import java.util.Map;
import reactor.util.annotation.Nullable;

public final class MessageTelemetryBuilder
extends AbstractTelemetryBuilder {
    private static final int MAX_MESSAGE_LENGTH = 32768;
    private final MessageData data;

    public static MessageTelemetryBuilder create() {
        return new MessageTelemetryBuilder(new MessageData());
    }

    private MessageTelemetryBuilder(MessageData data) {
        super(data, "Message", "MessageData");
        this.data = data;
    }

    public void setMessage(String message) {
        if (message.trim().isEmpty()) {
            message = "n/a";
        }
        this.data.setMessage(TelemetryTruncation.truncateTelemetry(message, 32768, "Message.message"));
    }

    public void setSeverityLevel(SeverityLevel severityLevel) {
        this.data.setSeverityLevel(severityLevel);
    }

    public void addMeasurement(@Nullable String key, Double value) {
        if (key == null || key.isEmpty() || key.length() > 150) {
            return;
        }
        Map<String, Double> measurements = this.data.getMeasurements();
        if (measurements == null) {
            measurements = new HashMap<String, Double>();
            this.data.setMeasurements(measurements);
        }
        measurements.put(key, value);
    }

    @Override
    protected Map<String, String> getProperties() {
        Map<String, String> properties = this.data.getProperties();
        if (properties == null) {
            properties = new HashMap<String, String>();
            this.data.setProperties(properties);
        }
        return properties;
    }
}

