/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.heartbeat;

import com.azure.core.util.logging.ClientLogger;
import com.azure.monitor.opentelemetry.exporter.implementation.heartbeat.HeartBeatPayloadProviderInterface;
import com.azure.monitor.opentelemetry.exporter.implementation.heartbeat.HeartbeatExporter;
import com.azure.monitor.opentelemetry.exporter.implementation.utils.Strings;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class WebAppsHeartbeatProvider
implements HeartBeatPayloadProviderInterface {
    private static final ClientLogger logger = new ClientLogger(WebAppsHeartbeatProvider.class);
    private final Set<String> defaultFields = new HashSet<String>();
    private Map<String, String> environmentMap = System.getenv();
    private static final String WEBSITE_SITE_NAME = "appSrv_SiteName";
    private static final String WEBSITE_HOSTNAME = "appSrv_wsHost";
    private static final String WEBSITE_HOME_STAMPNAME = "appSrv_wsStamp";
    private static final String WEBSITE_OWNER_NAME = "appSrv_wsOwner";
    private static final String WEBSITE_RESOURCE_GROUP = "appSrv_ResourceGroup";
    private static final String WEBSITE_SLOT_NAME = "appSrv_SlotName";

    public WebAppsHeartbeatProvider() {
        WebAppsHeartbeatProvider.initializeDefaultFields(this.defaultFields);
    }

    @Override
    public Runnable setDefaultPayload(final HeartbeatExporter provider) {
        return new Runnable(){
            final Set<String> enabledProperties;
            {
                this.enabledProperties = WebAppsHeartbeatProvider.this.defaultFields;
            }

            @Override
            public void run() {
                WebAppsHeartbeatProvider.this.updateEnvironmentVariableMap();
                for (String fieldName : this.enabledProperties) {
                    try {
                        switch (fieldName) {
                            case "appSrv_SiteName": {
                                String webSiteName = WebAppsHeartbeatProvider.this.getWebsiteSiteName();
                                if (Strings.isNullOrEmpty(webSiteName)) break;
                                provider.addHeartBeatProperty(fieldName, webSiteName, true);
                                break;
                            }
                            case "appSrv_wsHost": {
                                String webSiteHostName = WebAppsHeartbeatProvider.this.getWebsiteHostName();
                                if (Strings.isNullOrEmpty(webSiteHostName)) break;
                                provider.addHeartBeatProperty(fieldName, webSiteHostName, true);
                                break;
                            }
                            case "appSrv_wsStamp": {
                                String websiteHomeStampName = WebAppsHeartbeatProvider.this.getWebsiteHomeStampName();
                                if (Strings.isNullOrEmpty(websiteHomeStampName)) break;
                                provider.addHeartBeatProperty(fieldName, websiteHomeStampName, true);
                                break;
                            }
                            case "appSrv_wsOwner": {
                                String websiteOwnerName = WebAppsHeartbeatProvider.this.getWebsiteOwnerName();
                                if (Strings.isNullOrEmpty(websiteOwnerName)) break;
                                provider.addHeartBeatProperty(fieldName, websiteOwnerName, true);
                                break;
                            }
                            case "appSrv_ResourceGroup": {
                                String websiteResourceGroup = WebAppsHeartbeatProvider.this.getWebsiteResourceGroup();
                                if (Strings.isNullOrEmpty(websiteResourceGroup)) break;
                                provider.addHeartBeatProperty(fieldName, websiteResourceGroup, true);
                                break;
                            }
                            case "appSrv_SlotName": {
                                String websiteSlotName = WebAppsHeartbeatProvider.this.getWebsiteSlotName();
                                if (Strings.isNullOrEmpty(websiteSlotName)) break;
                                provider.addHeartBeatProperty(fieldName, websiteSlotName, true);
                                break;
                            }
                            default: {
                                logger.verbose("Unknown web apps property encountered");
                            }
                        }
                    }
                    catch (RuntimeException e) {
                        logger.warning("Failed to obtain heartbeat property", new Object[]{e});
                    }
                }
            }
        };
    }

    private static void initializeDefaultFields(Set<String> defaultFields) {
        defaultFields.add(WEBSITE_SITE_NAME);
        defaultFields.add(WEBSITE_HOSTNAME);
        defaultFields.add(WEBSITE_HOME_STAMPNAME);
        defaultFields.add(WEBSITE_OWNER_NAME);
        defaultFields.add(WEBSITE_RESOURCE_GROUP);
        defaultFields.add(WEBSITE_SLOT_NAME);
    }

    private String getWebsiteSiteName() {
        return this.environmentMap.get("WEBSITE_SITE_NAME");
    }

    private String getWebsiteHostName() {
        return this.environmentMap.get("WEBSITE_HOSTNAME");
    }

    private String getWebsiteHomeStampName() {
        return this.environmentMap.get("WEBSITE_HOME_STAMPNAME");
    }

    private String getWebsiteOwnerName() {
        return this.environmentMap.get("WEBSITE_OWNER_NAME");
    }

    private String getWebsiteResourceGroup() {
        return this.environmentMap.get("WEBSITE_RESOURCE_GROUP");
    }

    private String getWebsiteSlotName() {
        return this.environmentMap.get("WEBSITE_SLOT_NAME");
    }

    private void updateEnvironmentVariableMap() {
        this.environmentMap = System.getenv();
    }
}

