/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.logging;

import com.azure.monitor.opentelemetry.exporter.implementation.logging.AggregatingLogger;
import com.azure.monitor.opentelemetry.exporter.implementation.utils.AzureMonitorMsgId;
import org.slf4j.MDC;
import reactor.util.annotation.Nullable;

public class OperationLogger {
    public static final OperationLogger NOOP = new OperationLogger(null);
    @Nullable
    private final AggregatingLogger aggregatingLogger;

    public OperationLogger(Class<?> source, String operation) {
        this(source, operation, 300);
    }

    OperationLogger(Class<?> source, String operation, int intervalSeconds) {
        this(new AggregatingLogger(source, operation, true, intervalSeconds));
    }

    private OperationLogger(@Nullable AggregatingLogger aggregatingLogger) {
        this.aggregatingLogger = aggregatingLogger;
    }

    public void recordSuccess() {
        if (this.aggregatingLogger != null) {
            this.aggregatingLogger.recordSuccess();
        }
    }

    public void recordFailure(String failureMessage, AzureMonitorMsgId msgId) {
        if (this.aggregatingLogger != null) {
            try (MDC.MDCCloseable ignored = msgId.makeActive();){
                this.aggregatingLogger.recordWarning(failureMessage);
            }
        }
    }

    public void recordFailure(String failureMessage) {
        if (this.aggregatingLogger != null) {
            this.aggregatingLogger.recordWarning(failureMessage, null);
        }
    }

    public void recordFailure(String failureMessage, Throwable exception) {
        if (this.aggregatingLogger != null) {
            this.aggregatingLogger.recordWarning(failureMessage, exception);
        }
    }

    public void recordFailure(String failureMessage, @Nullable Throwable exception, AzureMonitorMsgId msgId) {
        try (MDC.MDCCloseable ignored = msgId.makeActive();){
            this.recordFailure(failureMessage, exception);
        }
    }
}

