/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.search.documents.implementation.SearchIndexClientImpl;
import com.azure.search.documents.implementation.models.AutocompleteRequest;
import com.azure.search.documents.implementation.models.ErrorResponseException;
import com.azure.search.documents.implementation.models.IndexBatch;
import com.azure.search.documents.implementation.models.RequestOptions;
import com.azure.search.documents.implementation.models.SearchDocumentsResult;
import com.azure.search.documents.implementation.models.SearchRequest;
import com.azure.search.documents.implementation.models.SuggestDocumentsResult;
import com.azure.search.documents.implementation.models.SuggestRequest;
import com.azure.search.documents.models.AutocompleteResult;
import com.azure.search.documents.models.IndexDocumentsResult;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public final class DocumentsImpl {
    private final DocumentsService service;
    private final SearchIndexClientImpl client;

    DocumentsImpl(SearchIndexClientImpl client) {
        this.service = (DocumentsService)RestProxy.create(DocumentsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Long>> countWithResponseAsync(RequestOptions requestOptions) {
        String accept = "application/json; odata.metadata=none";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return FluxUtil.withContext(context -> this.service.count(this.client.getEndpoint(), this.client.getIndexName(), xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=none", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Long>> countWithResponseAsync(RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=none";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.count(this.client.getEndpoint(), this.client.getIndexName(), xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=none", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Long> countAsync(RequestOptions requestOptions) {
        return this.countWithResponseAsync(requestOptions).flatMap(res -> Mono.justOrEmpty((Object)((Long)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Long> countAsync(RequestOptions requestOptions, Context context) {
        return this.countWithResponseAsync(requestOptions, context).flatMap(res -> Mono.justOrEmpty((Object)((Long)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Long> countWithResponse(RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=none";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.countSync(this.client.getEndpoint(), this.client.getIndexName(), xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=none", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public long count(RequestOptions requestOptions) {
        return (Long)this.countWithResponse(requestOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchDocumentsResult>> searchPostWithResponseAsync(SearchRequest searchRequest, RequestOptions requestOptions) {
        String accept = "application/json; odata.metadata=none";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return FluxUtil.withContext(context -> this.service.searchPost(this.client.getEndpoint(), this.client.getIndexName(), this.client.getApiVersion(), xMsClientRequestId, "application/json; odata.metadata=none", searchRequest, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchDocumentsResult>> searchPostWithResponseAsync(SearchRequest searchRequest, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=none";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.searchPost(this.client.getEndpoint(), this.client.getIndexName(), this.client.getApiVersion(), xMsClientRequestId, "application/json; odata.metadata=none", searchRequest, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchDocumentsResult> searchPostAsync(SearchRequest searchRequest, RequestOptions requestOptions) {
        return this.searchPostWithResponseAsync(searchRequest, requestOptions).flatMap(res -> Mono.justOrEmpty((Object)((SearchDocumentsResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchDocumentsResult> searchPostAsync(SearchRequest searchRequest, RequestOptions requestOptions, Context context) {
        return this.searchPostWithResponseAsync(searchRequest, requestOptions, context).flatMap(res -> Mono.justOrEmpty((Object)((SearchDocumentsResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchDocumentsResult> searchPostWithResponse(SearchRequest searchRequest, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=none";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.searchPostSync(this.client.getEndpoint(), this.client.getIndexName(), this.client.getApiVersion(), xMsClientRequestId, "application/json; odata.metadata=none", searchRequest, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchDocumentsResult searchPost(SearchRequest searchRequest, RequestOptions requestOptions) {
        return (SearchDocumentsResult)this.searchPostWithResponse(searchRequest, requestOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Map<String, Object>>> getWithResponseAsync(String key, List<String> selectedFields, RequestOptions requestOptions) {
        String accept = "application/json; odata.metadata=none";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        String selectedFieldsConverted = selectedFields == null ? null : selectedFields.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getIndexName(), key, selectedFieldsConverted, this.client.getApiVersion(), xMsClientRequestId, "application/json; odata.metadata=none", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Map<String, Object>>> getWithResponseAsync(String key, List<String> selectedFields, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=none";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        String selectedFieldsConverted = selectedFields == null ? null : selectedFields.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.get(this.client.getEndpoint(), this.client.getIndexName(), key, selectedFieldsConverted, this.client.getApiVersion(), xMsClientRequestId, "application/json; odata.metadata=none", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Map<String, Object>> getAsync(String key, List<String> selectedFields, RequestOptions requestOptions) {
        return this.getWithResponseAsync(key, selectedFields, requestOptions).flatMap(res -> Mono.justOrEmpty((Object)((Map)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Map<String, Object>> getAsync(String key, List<String> selectedFields, RequestOptions requestOptions, Context context) {
        return this.getWithResponseAsync(key, selectedFields, requestOptions, context).flatMap(res -> Mono.justOrEmpty((Object)((Map)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Map<String, Object>> getWithResponse(String key, List<String> selectedFields, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=none";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        String selectedFieldsConverted = selectedFields == null ? null : selectedFields.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.getSync(this.client.getEndpoint(), this.client.getIndexName(), key, selectedFieldsConverted, this.client.getApiVersion(), xMsClientRequestId, "application/json; odata.metadata=none", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Map<String, Object> get(String key, List<String> selectedFields, RequestOptions requestOptions) {
        return (Map)this.getWithResponse(key, selectedFields, requestOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SuggestDocumentsResult>> suggestPostWithResponseAsync(SuggestRequest suggestRequest, RequestOptions requestOptions) {
        String accept = "application/json; odata.metadata=none";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return FluxUtil.withContext(context -> this.service.suggestPost(this.client.getEndpoint(), this.client.getIndexName(), this.client.getApiVersion(), xMsClientRequestId, "application/json; odata.metadata=none", suggestRequest, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SuggestDocumentsResult>> suggestPostWithResponseAsync(SuggestRequest suggestRequest, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=none";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.suggestPost(this.client.getEndpoint(), this.client.getIndexName(), this.client.getApiVersion(), xMsClientRequestId, "application/json; odata.metadata=none", suggestRequest, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SuggestDocumentsResult> suggestPostAsync(SuggestRequest suggestRequest, RequestOptions requestOptions) {
        return this.suggestPostWithResponseAsync(suggestRequest, requestOptions).flatMap(res -> Mono.justOrEmpty((Object)((SuggestDocumentsResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SuggestDocumentsResult> suggestPostAsync(SuggestRequest suggestRequest, RequestOptions requestOptions, Context context) {
        return this.suggestPostWithResponseAsync(suggestRequest, requestOptions, context).flatMap(res -> Mono.justOrEmpty((Object)((SuggestDocumentsResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SuggestDocumentsResult> suggestPostWithResponse(SuggestRequest suggestRequest, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=none";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.suggestPostSync(this.client.getEndpoint(), this.client.getIndexName(), this.client.getApiVersion(), xMsClientRequestId, "application/json; odata.metadata=none", suggestRequest, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SuggestDocumentsResult suggestPost(SuggestRequest suggestRequest, RequestOptions requestOptions) {
        return (SuggestDocumentsResult)this.suggestPostWithResponse(suggestRequest, requestOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<IndexDocumentsResult>> indexWithResponseAsync(IndexBatch batch, RequestOptions requestOptions) {
        String accept = "application/json; odata.metadata=none";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return FluxUtil.withContext(context -> this.service.index(this.client.getEndpoint(), this.client.getIndexName(), this.client.getApiVersion(), xMsClientRequestId, "application/json; odata.metadata=none", batch, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<IndexDocumentsResult>> indexWithResponseAsync(IndexBatch batch, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=none";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.index(this.client.getEndpoint(), this.client.getIndexName(), this.client.getApiVersion(), xMsClientRequestId, "application/json; odata.metadata=none", batch, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<IndexDocumentsResult> indexAsync(IndexBatch batch, RequestOptions requestOptions) {
        return this.indexWithResponseAsync(batch, requestOptions).flatMap(res -> Mono.justOrEmpty((Object)((IndexDocumentsResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<IndexDocumentsResult> indexAsync(IndexBatch batch, RequestOptions requestOptions, Context context) {
        return this.indexWithResponseAsync(batch, requestOptions, context).flatMap(res -> Mono.justOrEmpty((Object)((IndexDocumentsResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<IndexDocumentsResult> indexWithResponse(IndexBatch batch, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=none";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.indexSync(this.client.getEndpoint(), this.client.getIndexName(), this.client.getApiVersion(), xMsClientRequestId, "application/json; odata.metadata=none", batch, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public IndexDocumentsResult index(IndexBatch batch, RequestOptions requestOptions) {
        return (IndexDocumentsResult)this.indexWithResponse(batch, requestOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AutocompleteResult>> autocompletePostWithResponseAsync(AutocompleteRequest autocompleteRequest, RequestOptions requestOptions) {
        String accept = "application/json; odata.metadata=none";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return FluxUtil.withContext(context -> this.service.autocompletePost(this.client.getEndpoint(), this.client.getIndexName(), xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=none", autocompleteRequest, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AutocompleteResult>> autocompletePostWithResponseAsync(AutocompleteRequest autocompleteRequest, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=none";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.autocompletePost(this.client.getEndpoint(), this.client.getIndexName(), xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=none", autocompleteRequest, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AutocompleteResult> autocompletePostAsync(AutocompleteRequest autocompleteRequest, RequestOptions requestOptions) {
        return this.autocompletePostWithResponseAsync(autocompleteRequest, requestOptions).flatMap(res -> Mono.justOrEmpty((Object)((AutocompleteResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AutocompleteResult> autocompletePostAsync(AutocompleteRequest autocompleteRequest, RequestOptions requestOptions, Context context) {
        return this.autocompletePostWithResponseAsync(autocompleteRequest, requestOptions, context).flatMap(res -> Mono.justOrEmpty((Object)((AutocompleteResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AutocompleteResult> autocompletePostWithResponse(AutocompleteRequest autocompleteRequest, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=none";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.autocompletePostSync(this.client.getEndpoint(), this.client.getIndexName(), xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=none", autocompleteRequest, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AutocompleteResult autocompletePost(AutocompleteRequest autocompleteRequest, RequestOptions requestOptions) {
        return (AutocompleteResult)this.autocompletePostWithResponse(autocompleteRequest, requestOptions, Context.NONE).getValue();
    }

    @Host(value="{endpoint}/indexes('{indexName}')")
    @ServiceInterface(name="SearchIndexClientDoc")
    public static interface DocumentsService {
        @Get(value="/docs/$count")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Long>> count(@HostParam(value="endpoint") String var1, @HostParam(value="indexName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/docs/$count")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<Long> countSync(@HostParam(value="endpoint") String var1, @HostParam(value="indexName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/docs/search.post.search")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<SearchDocumentsResult>> searchPost(@HostParam(value="endpoint") String var1, @HostParam(value="indexName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="x-ms-client-request-id") UUID var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json") SearchRequest var6, Context var7);

        @Post(value="/docs/search.post.search")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<SearchDocumentsResult> searchPostSync(@HostParam(value="endpoint") String var1, @HostParam(value="indexName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="x-ms-client-request-id") UUID var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json") SearchRequest var6, Context var7);

        @Get(value="/docs('{key}')")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Map<String, Object>>> get(@HostParam(value="endpoint") String var1, @HostParam(value="indexName") String var2, @PathParam(value="key") String var3, @QueryParam(value="$select") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="x-ms-client-request-id") UUID var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/docs('{key}')")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<Map<String, Object>> getSync(@HostParam(value="endpoint") String var1, @HostParam(value="indexName") String var2, @PathParam(value="key") String var3, @QueryParam(value="$select") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="x-ms-client-request-id") UUID var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Post(value="/docs/search.post.suggest")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<SuggestDocumentsResult>> suggestPost(@HostParam(value="endpoint") String var1, @HostParam(value="indexName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="x-ms-client-request-id") UUID var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json") SuggestRequest var6, Context var7);

        @Post(value="/docs/search.post.suggest")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<SuggestDocumentsResult> suggestPostSync(@HostParam(value="endpoint") String var1, @HostParam(value="indexName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="x-ms-client-request-id") UUID var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json") SuggestRequest var6, Context var7);

        @Post(value="/docs/search.index")
        @ExpectedResponses(value={200, 207})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<IndexDocumentsResult>> index(@HostParam(value="endpoint") String var1, @HostParam(value="indexName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="x-ms-client-request-id") UUID var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json") IndexBatch var6, Context var7);

        @Post(value="/docs/search.index")
        @ExpectedResponses(value={200, 207})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<IndexDocumentsResult> indexSync(@HostParam(value="endpoint") String var1, @HostParam(value="indexName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="x-ms-client-request-id") UUID var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json") IndexBatch var6, Context var7);

        @Post(value="/docs/search.post.autocomplete")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<AutocompleteResult>> autocompletePost(@HostParam(value="endpoint") String var1, @HostParam(value="indexName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json") AutocompleteRequest var6, Context var7);

        @Post(value="/docs/search.post.autocomplete")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<AutocompleteResult> autocompletePostSync(@HostParam(value="endpoint") String var1, @HostParam(value="indexName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json") AutocompleteRequest var6, Context var7);
    }
}

