/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;

public final class SuggestRequest
implements JsonSerializable<SuggestRequest> {
    private String filter;
    private Boolean useFuzzyMatching;
    private String highlightPostTag;
    private String highlightPreTag;
    private Double minimumCoverage;
    private String orderBy;
    private final String searchText;
    private String searchFields;
    private String select;
    private final String suggesterName;
    private Integer top;

    public SuggestRequest(String searchText, String suggesterName) {
        this.searchText = searchText;
        this.suggesterName = suggesterName;
    }

    public String getFilter() {
        return this.filter;
    }

    public SuggestRequest setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    public Boolean isUseFuzzyMatching() {
        return this.useFuzzyMatching;
    }

    public SuggestRequest setUseFuzzyMatching(Boolean useFuzzyMatching) {
        this.useFuzzyMatching = useFuzzyMatching;
        return this;
    }

    public String getHighlightPostTag() {
        return this.highlightPostTag;
    }

    public SuggestRequest setHighlightPostTag(String highlightPostTag) {
        this.highlightPostTag = highlightPostTag;
        return this;
    }

    public String getHighlightPreTag() {
        return this.highlightPreTag;
    }

    public SuggestRequest setHighlightPreTag(String highlightPreTag) {
        this.highlightPreTag = highlightPreTag;
        return this;
    }

    public Double getMinimumCoverage() {
        return this.minimumCoverage;
    }

    public SuggestRequest setMinimumCoverage(Double minimumCoverage) {
        this.minimumCoverage = minimumCoverage;
        return this;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public SuggestRequest setOrderBy(String orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public String getSearchText() {
        return this.searchText;
    }

    public String getSearchFields() {
        return this.searchFields;
    }

    public SuggestRequest setSearchFields(String searchFields) {
        this.searchFields = searchFields;
        return this;
    }

    public String getSelect() {
        return this.select;
    }

    public SuggestRequest setSelect(String select) {
        this.select = select;
        return this;
    }

    public String getSuggesterName() {
        return this.suggesterName;
    }

    public Integer getTop() {
        return this.top;
    }

    public SuggestRequest setTop(Integer top) {
        this.top = top;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("search", this.searchText);
        jsonWriter.writeStringField("suggesterName", this.suggesterName);
        jsonWriter.writeStringField("filter", this.filter);
        jsonWriter.writeBooleanField("fuzzy", this.useFuzzyMatching);
        jsonWriter.writeStringField("highlightPostTag", this.highlightPostTag);
        jsonWriter.writeStringField("highlightPreTag", this.highlightPreTag);
        jsonWriter.writeNumberField("minimumCoverage", (Number)this.minimumCoverage);
        jsonWriter.writeStringField("orderby", this.orderBy);
        jsonWriter.writeStringField("searchFields", this.searchFields);
        jsonWriter.writeStringField("select", this.select);
        jsonWriter.writeNumberField("top", (Number)this.top);
        return jsonWriter.writeEndObject();
    }

    public static SuggestRequest fromJson(JsonReader jsonReader) throws IOException {
        return (SuggestRequest)jsonReader.readObject(reader -> {
            boolean searchTextFound = false;
            String searchText = null;
            boolean suggesterNameFound = false;
            String suggesterName = null;
            String filter = null;
            Boolean useFuzzyMatching = null;
            String highlightPostTag = null;
            String highlightPreTag = null;
            Double minimumCoverage = null;
            String orderBy = null;
            String searchFields = null;
            String select = null;
            Integer top = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("search".equals(fieldName)) {
                    searchText = reader.getString();
                    searchTextFound = true;
                    continue;
                }
                if ("suggesterName".equals(fieldName)) {
                    suggesterName = reader.getString();
                    suggesterNameFound = true;
                    continue;
                }
                if ("filter".equals(fieldName)) {
                    filter = reader.getString();
                    continue;
                }
                if ("fuzzy".equals(fieldName)) {
                    useFuzzyMatching = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("highlightPostTag".equals(fieldName)) {
                    highlightPostTag = reader.getString();
                    continue;
                }
                if ("highlightPreTag".equals(fieldName)) {
                    highlightPreTag = reader.getString();
                    continue;
                }
                if ("minimumCoverage".equals(fieldName)) {
                    minimumCoverage = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("orderby".equals(fieldName)) {
                    orderBy = reader.getString();
                    continue;
                }
                if ("searchFields".equals(fieldName)) {
                    searchFields = reader.getString();
                    continue;
                }
                if ("select".equals(fieldName)) {
                    select = reader.getString();
                    continue;
                }
                if ("top".equals(fieldName)) {
                    top = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            if (searchTextFound && suggesterNameFound) {
                SuggestRequest deserializedSuggestRequest = new SuggestRequest(searchText, suggesterName);
                deserializedSuggestRequest.filter = filter;
                deserializedSuggestRequest.useFuzzyMatching = useFuzzyMatching;
                deserializedSuggestRequest.highlightPostTag = highlightPostTag;
                deserializedSuggestRequest.highlightPreTag = highlightPreTag;
                deserializedSuggestRequest.minimumCoverage = minimumCoverage;
                deserializedSuggestRequest.orderBy = orderBy;
                deserializedSuggestRequest.searchFields = searchFields;
                deserializedSuggestRequest.select = select;
                deserializedSuggestRequest.top = top;
                return deserializedSuggestRequest;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!searchTextFound) {
                missingProperties.add("search");
            }
            if (!suggesterNameFound) {
                missingProperties.add("suggesterName");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

