/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.administration.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.security.keyvault.administration.implementation.models.FullBackupHeaders;
import com.azure.security.keyvault.administration.implementation.models.FullBackupOperation;
import com.azure.security.keyvault.administration.implementation.models.FullRestoreOperationHeaders;
import com.azure.security.keyvault.administration.implementation.models.KeyVaultErrorException;
import com.azure.security.keyvault.administration.implementation.models.RestoreOperation;
import com.azure.security.keyvault.administration.implementation.models.RestoreOperationParameters;
import com.azure.security.keyvault.administration.implementation.models.SASTokenParameter;
import com.azure.security.keyvault.administration.implementation.models.SelectiveKeyRestoreOperation;
import com.azure.security.keyvault.administration.implementation.models.SelectiveKeyRestoreOperationHeaders;
import com.azure.security.keyvault.administration.implementation.models.SelectiveKeyRestoreOperationParameters;
import reactor.core.publisher.Mono;

public final class KeyVaultBackupClientImpl {
    private final KeyVaultBackupClientService service;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;

    public String getApiVersion() {
        return this.apiVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public KeyVaultBackupClientImpl(String apiVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), apiVersion);
    }

    public KeyVaultBackupClientImpl(HttpPipeline httpPipeline, String apiVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), apiVersion);
    }

    public KeyVaultBackupClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String apiVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.apiVersion = apiVersion;
        this.service = (KeyVaultBackupClientService)RestProxy.create(KeyVaultBackupClientService.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)this.getSerializerAdapter());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FullBackupHeaders, FullBackupOperation>> fullBackupWithResponseAsync(String vaultBaseUrl, SASTokenParameter azureStorageBlobContainerUri) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.fullBackup(vaultBaseUrl, this.getApiVersion(), azureStorageBlobContainerUri, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FullBackupHeaders, FullBackupOperation>> fullBackupWithResponseAsync(String vaultBaseUrl, SASTokenParameter azureStorageBlobContainerUri, Context context) {
        String accept = "application/json";
        return this.service.fullBackup(vaultBaseUrl, this.getApiVersion(), azureStorageBlobContainerUri, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FullBackupOperation> fullBackupAsync(String vaultBaseUrl, SASTokenParameter azureStorageBlobContainerUri) {
        return this.fullBackupWithResponseAsync(vaultBaseUrl, azureStorageBlobContainerUri).flatMap(res -> Mono.justOrEmpty((Object)((FullBackupOperation)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FullBackupOperation> fullBackupAsync(String vaultBaseUrl, SASTokenParameter azureStorageBlobContainerUri, Context context) {
        return this.fullBackupWithResponseAsync(vaultBaseUrl, azureStorageBlobContainerUri, context).flatMap(res -> Mono.justOrEmpty((Object)((FullBackupOperation)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<FullBackupHeaders, FullBackupOperation> fullBackupWithResponse(String vaultBaseUrl, SASTokenParameter azureStorageBlobContainerUri, Context context) {
        String accept = "application/json";
        return this.service.fullBackupSync(vaultBaseUrl, this.getApiVersion(), azureStorageBlobContainerUri, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public FullBackupOperation fullBackup(String vaultBaseUrl, SASTokenParameter azureStorageBlobContainerUri) {
        return (FullBackupOperation)this.fullBackupWithResponse(vaultBaseUrl, azureStorageBlobContainerUri, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<FullBackupOperation>> fullBackupStatusWithResponseAsync(String vaultBaseUrl, String jobId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.fullBackupStatus(vaultBaseUrl, jobId, this.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<FullBackupOperation>> fullBackupStatusWithResponseAsync(String vaultBaseUrl, String jobId, Context context) {
        String accept = "application/json";
        return this.service.fullBackupStatus(vaultBaseUrl, jobId, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FullBackupOperation> fullBackupStatusAsync(String vaultBaseUrl, String jobId) {
        return this.fullBackupStatusWithResponseAsync(vaultBaseUrl, jobId).flatMap(res -> Mono.justOrEmpty((Object)((FullBackupOperation)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FullBackupOperation> fullBackupStatusAsync(String vaultBaseUrl, String jobId, Context context) {
        return this.fullBackupStatusWithResponseAsync(vaultBaseUrl, jobId, context).flatMap(res -> Mono.justOrEmpty((Object)((FullBackupOperation)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<FullBackupOperation> fullBackupStatusWithResponse(String vaultBaseUrl, String jobId, Context context) {
        String accept = "application/json";
        return this.service.fullBackupStatusSync(vaultBaseUrl, jobId, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public FullBackupOperation fullBackupStatus(String vaultBaseUrl, String jobId) {
        return (FullBackupOperation)this.fullBackupStatusWithResponse(vaultBaseUrl, jobId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FullRestoreOperationHeaders, RestoreOperation>> fullRestoreOperationWithResponseAsync(String vaultBaseUrl, RestoreOperationParameters restoreBlobDetails) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.fullRestoreOperation(vaultBaseUrl, this.getApiVersion(), restoreBlobDetails, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FullRestoreOperationHeaders, RestoreOperation>> fullRestoreOperationWithResponseAsync(String vaultBaseUrl, RestoreOperationParameters restoreBlobDetails, Context context) {
        String accept = "application/json";
        return this.service.fullRestoreOperation(vaultBaseUrl, this.getApiVersion(), restoreBlobDetails, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RestoreOperation> fullRestoreOperationAsync(String vaultBaseUrl, RestoreOperationParameters restoreBlobDetails) {
        return this.fullRestoreOperationWithResponseAsync(vaultBaseUrl, restoreBlobDetails).flatMap(res -> Mono.justOrEmpty((Object)((RestoreOperation)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RestoreOperation> fullRestoreOperationAsync(String vaultBaseUrl, RestoreOperationParameters restoreBlobDetails, Context context) {
        return this.fullRestoreOperationWithResponseAsync(vaultBaseUrl, restoreBlobDetails, context).flatMap(res -> Mono.justOrEmpty((Object)((RestoreOperation)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<FullRestoreOperationHeaders, RestoreOperation> fullRestoreOperationWithResponse(String vaultBaseUrl, RestoreOperationParameters restoreBlobDetails, Context context) {
        String accept = "application/json";
        return this.service.fullRestoreOperationSync(vaultBaseUrl, this.getApiVersion(), restoreBlobDetails, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RestoreOperation fullRestoreOperation(String vaultBaseUrl, RestoreOperationParameters restoreBlobDetails) {
        return (RestoreOperation)this.fullRestoreOperationWithResponse(vaultBaseUrl, restoreBlobDetails, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RestoreOperation>> restoreStatusWithResponseAsync(String vaultBaseUrl, String jobId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.restoreStatus(vaultBaseUrl, jobId, this.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RestoreOperation>> restoreStatusWithResponseAsync(String vaultBaseUrl, String jobId, Context context) {
        String accept = "application/json";
        return this.service.restoreStatus(vaultBaseUrl, jobId, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RestoreOperation> restoreStatusAsync(String vaultBaseUrl, String jobId) {
        return this.restoreStatusWithResponseAsync(vaultBaseUrl, jobId).flatMap(res -> Mono.justOrEmpty((Object)((RestoreOperation)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RestoreOperation> restoreStatusAsync(String vaultBaseUrl, String jobId, Context context) {
        return this.restoreStatusWithResponseAsync(vaultBaseUrl, jobId, context).flatMap(res -> Mono.justOrEmpty((Object)((RestoreOperation)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RestoreOperation> restoreStatusWithResponse(String vaultBaseUrl, String jobId, Context context) {
        String accept = "application/json";
        return this.service.restoreStatusSync(vaultBaseUrl, jobId, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RestoreOperation restoreStatus(String vaultBaseUrl, String jobId) {
        return (RestoreOperation)this.restoreStatusWithResponse(vaultBaseUrl, jobId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SelectiveKeyRestoreOperationHeaders, SelectiveKeyRestoreOperation>> selectiveKeyRestoreOperationWithResponseAsync(String vaultBaseUrl, String keyName, SelectiveKeyRestoreOperationParameters restoreBlobDetails) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.selectiveKeyRestoreOperation(vaultBaseUrl, keyName, this.getApiVersion(), restoreBlobDetails, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SelectiveKeyRestoreOperationHeaders, SelectiveKeyRestoreOperation>> selectiveKeyRestoreOperationWithResponseAsync(String vaultBaseUrl, String keyName, SelectiveKeyRestoreOperationParameters restoreBlobDetails, Context context) {
        String accept = "application/json";
        return this.service.selectiveKeyRestoreOperation(vaultBaseUrl, keyName, this.getApiVersion(), restoreBlobDetails, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SelectiveKeyRestoreOperation> selectiveKeyRestoreOperationAsync(String vaultBaseUrl, String keyName, SelectiveKeyRestoreOperationParameters restoreBlobDetails) {
        return this.selectiveKeyRestoreOperationWithResponseAsync(vaultBaseUrl, keyName, restoreBlobDetails).flatMap(res -> Mono.justOrEmpty((Object)((SelectiveKeyRestoreOperation)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SelectiveKeyRestoreOperation> selectiveKeyRestoreOperationAsync(String vaultBaseUrl, String keyName, SelectiveKeyRestoreOperationParameters restoreBlobDetails, Context context) {
        return this.selectiveKeyRestoreOperationWithResponseAsync(vaultBaseUrl, keyName, restoreBlobDetails, context).flatMap(res -> Mono.justOrEmpty((Object)((SelectiveKeyRestoreOperation)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<SelectiveKeyRestoreOperationHeaders, SelectiveKeyRestoreOperation> selectiveKeyRestoreOperationWithResponse(String vaultBaseUrl, String keyName, SelectiveKeyRestoreOperationParameters restoreBlobDetails, Context context) {
        String accept = "application/json";
        return this.service.selectiveKeyRestoreOperationSync(vaultBaseUrl, keyName, this.getApiVersion(), restoreBlobDetails, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SelectiveKeyRestoreOperation selectiveKeyRestoreOperation(String vaultBaseUrl, String keyName, SelectiveKeyRestoreOperationParameters restoreBlobDetails) {
        return (SelectiveKeyRestoreOperation)this.selectiveKeyRestoreOperationWithResponse(vaultBaseUrl, keyName, restoreBlobDetails, Context.NONE).getValue();
    }

    @Host(value="{vaultBaseUrl}")
    @ServiceInterface(name="KeyVaultBackupClient")
    public static interface KeyVaultBackupClientService {
        @Post(value="/backup")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<ResponseBase<FullBackupHeaders, FullBackupOperation>> fullBackup(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") SASTokenParameter var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/backup")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public ResponseBase<FullBackupHeaders, FullBackupOperation> fullBackupSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") SASTokenParameter var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/backup/{jobId}/pending")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<FullBackupOperation>> fullBackupStatus(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="jobId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/backup/{jobId}/pending")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<FullBackupOperation> fullBackupStatusSync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="jobId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Put(value="/restore")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<ResponseBase<FullRestoreOperationHeaders, RestoreOperation>> fullRestoreOperation(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") RestoreOperationParameters var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Put(value="/restore")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public ResponseBase<FullRestoreOperationHeaders, RestoreOperation> fullRestoreOperationSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") RestoreOperationParameters var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/restore/{jobId}/pending")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<RestoreOperation>> restoreStatus(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="jobId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/restore/{jobId}/pending")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<RestoreOperation> restoreStatusSync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="jobId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Put(value="/keys/{keyName}/restore")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<ResponseBase<SelectiveKeyRestoreOperationHeaders, SelectiveKeyRestoreOperation>> selectiveKeyRestoreOperation(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="keyName") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") SelectiveKeyRestoreOperationParameters var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Put(value="/keys/{keyName}/restore")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public ResponseBase<SelectiveKeyRestoreOperationHeaders, SelectiveKeyRestoreOperation> selectiveKeyRestoreOperationSync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="keyName") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") SelectiveKeyRestoreOperationParameters var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

