/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.administration.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.security.keyvault.administration.implementation.KeyVaultAccessControlClientImpl;
import com.azure.security.keyvault.administration.implementation.models.KeyVaultErrorException;
import com.azure.security.keyvault.administration.implementation.models.RoleDefinition;
import com.azure.security.keyvault.administration.implementation.models.RoleDefinitionCreateParameters;
import com.azure.security.keyvault.administration.implementation.models.RoleDefinitionListResult;
import reactor.core.publisher.Mono;

public final class RoleDefinitionsImpl {
    private final RoleDefinitionsService service;
    private final KeyVaultAccessControlClientImpl client;

    RoleDefinitionsImpl(KeyVaultAccessControlClientImpl client) {
        this.service = (RoleDefinitionsService)RestProxy.create(RoleDefinitionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RoleDefinition>> deleteWithResponseAsync(String vaultBaseUrl, String scope, String roleDefinitionName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(vaultBaseUrl, scope, roleDefinitionName, this.client.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RoleDefinition>> deleteWithResponseAsync(String vaultBaseUrl, String scope, String roleDefinitionName, Context context) {
        String accept = "application/json";
        return this.service.delete(vaultBaseUrl, scope, roleDefinitionName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RoleDefinition> deleteAsync(String vaultBaseUrl, String scope, String roleDefinitionName) {
        return this.deleteWithResponseAsync(vaultBaseUrl, scope, roleDefinitionName).flatMap(res -> Mono.justOrEmpty((Object)((RoleDefinition)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RoleDefinition> deleteAsync(String vaultBaseUrl, String scope, String roleDefinitionName, Context context) {
        return this.deleteWithResponseAsync(vaultBaseUrl, scope, roleDefinitionName, context).flatMap(res -> Mono.justOrEmpty((Object)((RoleDefinition)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RoleDefinition> deleteWithResponse(String vaultBaseUrl, String scope, String roleDefinitionName, Context context) {
        String accept = "application/json";
        return this.service.deleteSync(vaultBaseUrl, scope, roleDefinitionName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RoleDefinition delete(String vaultBaseUrl, String scope, String roleDefinitionName) {
        return (RoleDefinition)this.deleteWithResponse(vaultBaseUrl, scope, roleDefinitionName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RoleDefinition>> createOrUpdateWithResponseAsync(String vaultBaseUrl, String scope, String roleDefinitionName, RoleDefinitionCreateParameters parameters) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(vaultBaseUrl, scope, roleDefinitionName, this.client.getApiVersion(), parameters, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RoleDefinition>> createOrUpdateWithResponseAsync(String vaultBaseUrl, String scope, String roleDefinitionName, RoleDefinitionCreateParameters parameters, Context context) {
        String accept = "application/json";
        return this.service.createOrUpdate(vaultBaseUrl, scope, roleDefinitionName, this.client.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RoleDefinition> createOrUpdateAsync(String vaultBaseUrl, String scope, String roleDefinitionName, RoleDefinitionCreateParameters parameters) {
        return this.createOrUpdateWithResponseAsync(vaultBaseUrl, scope, roleDefinitionName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((RoleDefinition)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RoleDefinition> createOrUpdateAsync(String vaultBaseUrl, String scope, String roleDefinitionName, RoleDefinitionCreateParameters parameters, Context context) {
        return this.createOrUpdateWithResponseAsync(vaultBaseUrl, scope, roleDefinitionName, parameters, context).flatMap(res -> Mono.justOrEmpty((Object)((RoleDefinition)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RoleDefinition> createOrUpdateWithResponse(String vaultBaseUrl, String scope, String roleDefinitionName, RoleDefinitionCreateParameters parameters, Context context) {
        String accept = "application/json";
        return this.service.createOrUpdateSync(vaultBaseUrl, scope, roleDefinitionName, this.client.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RoleDefinition createOrUpdate(String vaultBaseUrl, String scope, String roleDefinitionName, RoleDefinitionCreateParameters parameters) {
        return (RoleDefinition)this.createOrUpdateWithResponse(vaultBaseUrl, scope, roleDefinitionName, parameters, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RoleDefinition>> getWithResponseAsync(String vaultBaseUrl, String scope, String roleDefinitionName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(vaultBaseUrl, scope, roleDefinitionName, this.client.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RoleDefinition>> getWithResponseAsync(String vaultBaseUrl, String scope, String roleDefinitionName, Context context) {
        String accept = "application/json";
        return this.service.get(vaultBaseUrl, scope, roleDefinitionName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RoleDefinition> getAsync(String vaultBaseUrl, String scope, String roleDefinitionName) {
        return this.getWithResponseAsync(vaultBaseUrl, scope, roleDefinitionName).flatMap(res -> Mono.justOrEmpty((Object)((RoleDefinition)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RoleDefinition> getAsync(String vaultBaseUrl, String scope, String roleDefinitionName, Context context) {
        return this.getWithResponseAsync(vaultBaseUrl, scope, roleDefinitionName, context).flatMap(res -> Mono.justOrEmpty((Object)((RoleDefinition)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RoleDefinition> getWithResponse(String vaultBaseUrl, String scope, String roleDefinitionName, Context context) {
        String accept = "application/json";
        return this.service.getSync(vaultBaseUrl, scope, roleDefinitionName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RoleDefinition get(String vaultBaseUrl, String scope, String roleDefinitionName) {
        return (RoleDefinition)this.getWithResponse(vaultBaseUrl, scope, roleDefinitionName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<RoleDefinition>> listSinglePageAsync(String vaultBaseUrl, String scope, String filter) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(vaultBaseUrl, scope, filter, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleDefinitionListResult)res.getValue()).getValue(), ((RoleDefinitionListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<RoleDefinition>> listSinglePageAsync(String vaultBaseUrl, String scope, String filter, Context context) {
        String accept = "application/json";
        return this.service.list(vaultBaseUrl, scope, filter, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleDefinitionListResult)res.getValue()).getValue(), ((RoleDefinitionListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RoleDefinition> listAsync(String vaultBaseUrl, String scope, String filter) {
        return new PagedFlux(() -> this.listSinglePageAsync(vaultBaseUrl, scope, filter), nextLink -> this.listNextSinglePageAsync((String)nextLink, vaultBaseUrl));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RoleDefinition> listAsync(String vaultBaseUrl, String scope, String filter, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(vaultBaseUrl, scope, filter, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, vaultBaseUrl, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<RoleDefinition> listSinglePage(String vaultBaseUrl, String scope, String filter) {
        String accept = "application/json";
        Response<RoleDefinitionListResult> res = this.service.listSync(vaultBaseUrl, scope, filter, this.client.getApiVersion(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleDefinitionListResult)res.getValue()).getValue(), ((RoleDefinitionListResult)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<RoleDefinition> listSinglePage(String vaultBaseUrl, String scope, String filter, Context context) {
        String accept = "application/json";
        Response<RoleDefinitionListResult> res = this.service.listSync(vaultBaseUrl, scope, filter, this.client.getApiVersion(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleDefinitionListResult)res.getValue()).getValue(), ((RoleDefinitionListResult)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RoleDefinition> list(String vaultBaseUrl, String scope, String filter) {
        return new PagedIterable(() -> this.listSinglePage(vaultBaseUrl, scope, filter, Context.NONE), nextLink -> this.listNextSinglePage((String)nextLink, vaultBaseUrl));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RoleDefinition> list(String vaultBaseUrl, String scope, String filter, Context context) {
        return new PagedIterable(() -> this.listSinglePage(vaultBaseUrl, scope, filter, context), nextLink -> this.listNextSinglePage((String)nextLink, vaultBaseUrl, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<RoleDefinition>> listNextSinglePageAsync(String nextLink, String vaultBaseUrl) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, vaultBaseUrl, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleDefinitionListResult)res.getValue()).getValue(), ((RoleDefinitionListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<RoleDefinition>> listNextSinglePageAsync(String nextLink, String vaultBaseUrl, Context context) {
        String accept = "application/json";
        return this.service.listNext(nextLink, vaultBaseUrl, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleDefinitionListResult)res.getValue()).getValue(), ((RoleDefinitionListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<RoleDefinition> listNextSinglePage(String nextLink, String vaultBaseUrl) {
        String accept = "application/json";
        Response<RoleDefinitionListResult> res = this.service.listNextSync(nextLink, vaultBaseUrl, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleDefinitionListResult)res.getValue()).getValue(), ((RoleDefinitionListResult)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<RoleDefinition> listNextSinglePage(String nextLink, String vaultBaseUrl, Context context) {
        String accept = "application/json";
        Response<RoleDefinitionListResult> res = this.service.listNextSync(nextLink, vaultBaseUrl, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleDefinitionListResult)res.getValue()).getValue(), ((RoleDefinitionListResult)res.getValue()).getNextLink(), null);
    }

    @Host(value="{vaultBaseUrl}")
    @ServiceInterface(name="KeyVaultAccessContro")
    public static interface RoleDefinitionsService {
        @Delete(value="/{scope}/providers/Microsoft.Authorization/roleDefinitions/{roleDefinitionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<RoleDefinition>> delete(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="scope", encoded=true) String var2, @PathParam(value="roleDefinitionName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Delete(value="/{scope}/providers/Microsoft.Authorization/roleDefinitions/{roleDefinitionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<RoleDefinition> deleteSync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="scope", encoded=true) String var2, @PathParam(value="roleDefinitionName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Put(value="/{scope}/providers/Microsoft.Authorization/roleDefinitions/{roleDefinitionName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<RoleDefinition>> createOrUpdate(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="scope", encoded=true) String var2, @PathParam(value="roleDefinitionName") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") RoleDefinitionCreateParameters var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Put(value="/{scope}/providers/Microsoft.Authorization/roleDefinitions/{roleDefinitionName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<RoleDefinition> createOrUpdateSync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="scope", encoded=true) String var2, @PathParam(value="roleDefinitionName") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") RoleDefinitionCreateParameters var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Get(value="/{scope}/providers/Microsoft.Authorization/roleDefinitions/{roleDefinitionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<RoleDefinition>> get(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="scope", encoded=true) String var2, @PathParam(value="roleDefinitionName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/{scope}/providers/Microsoft.Authorization/roleDefinitions/{roleDefinitionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<RoleDefinition> getSync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="scope", encoded=true) String var2, @PathParam(value="roleDefinitionName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/{scope}/providers/Microsoft.Authorization/roleDefinitions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<RoleDefinitionListResult>> list(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="scope", encoded=true) String var2, @QueryParam(value="$filter") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/{scope}/providers/Microsoft.Authorization/roleDefinitions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<RoleDefinitionListResult> listSync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="scope", encoded=true) String var2, @QueryParam(value="$filter") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<RoleDefinitionListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="vaultBaseUrl") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<RoleDefinitionListResult> listNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="vaultBaseUrl") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

