/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.certificates.implementation.CertificatePolicyHelper;
import com.azure.security.keyvault.certificates.implementation.models.CertificateAttributes;
import com.azure.security.keyvault.certificates.implementation.models.IssuerParameters;
import com.azure.security.keyvault.certificates.implementation.models.KeyProperties;
import com.azure.security.keyvault.certificates.implementation.models.SecretProperties;
import com.azure.security.keyvault.certificates.implementation.models.X509CertificateProperties;
import com.azure.security.keyvault.certificates.models.CertificateContentType;
import com.azure.security.keyvault.certificates.models.CertificateKeyCurveName;
import com.azure.security.keyvault.certificates.models.CertificateKeyType;
import com.azure.security.keyvault.certificates.models.CertificateKeyUsage;
import com.azure.security.keyvault.certificates.models.LifetimeAction;
import com.azure.security.keyvault.certificates.models.SubjectAlternativeNames;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class CertificatePolicy
implements JsonSerializable<CertificatePolicy> {
    private final com.azure.security.keyvault.certificates.implementation.models.CertificatePolicy impl;
    private List<LifetimeAction> lifetimeActions;

    public CertificatePolicy(String issuerName, String subject) {
        this.impl = new com.azure.security.keyvault.certificates.implementation.models.CertificatePolicy().setIssuerParameters(new IssuerParameters().setName(issuerName)).setX509CertificateProperties(new X509CertificateProperties().setSubject(subject));
    }

    public CertificatePolicy(String issuerName, SubjectAlternativeNames subjectAlternativeNames) {
        this.impl = new com.azure.security.keyvault.certificates.implementation.models.CertificatePolicy().setIssuerParameters(new IssuerParameters().setName(issuerName)).setX509CertificateProperties(new X509CertificateProperties().setSubjectAlternativeNames(subjectAlternativeNames));
    }

    public CertificatePolicy(String issuerName, String subject, SubjectAlternativeNames subjectAlternativeNames) {
        this.impl = new com.azure.security.keyvault.certificates.implementation.models.CertificatePolicy().setIssuerParameters(new IssuerParameters().setName(issuerName)).setX509CertificateProperties(new X509CertificateProperties().setSubject(subject).setSubjectAlternativeNames(subjectAlternativeNames));
    }

    private CertificatePolicy(com.azure.security.keyvault.certificates.implementation.models.CertificatePolicy impl) {
        this.impl = impl;
    }

    public List<CertificateKeyUsage> getKeyUsage() {
        return this.impl.getX509CertificateProperties().getKeyUsage();
    }

    public CertificatePolicy setKeyUsage(CertificateKeyUsage ... keyUsage) {
        if (keyUsage == null) {
            this.impl.getX509CertificateProperties().setKeyUsage(null);
        } else {
            this.impl.getX509CertificateProperties().setKeyUsage(Arrays.asList(keyUsage));
        }
        return this;
    }

    public List<String> getEnhancedKeyUsage() {
        return this.impl.getX509CertificateProperties().getEkus();
    }

    public CertificatePolicy setEnhancedKeyUsage(List<String> ekus) {
        this.impl.getX509CertificateProperties().setEkus(ekus);
        return this;
    }

    public Boolean isExportable() {
        return this.impl.getKeyProperties() == null ? null : this.impl.getKeyProperties().isExportable();
    }

    public CertificatePolicy setExportable(Boolean exportable) {
        if (this.impl.getKeyProperties() == null) {
            this.impl.setKeyProperties(new KeyProperties());
        }
        this.impl.getKeyProperties().setExportable(exportable);
        return this;
    }

    public CertificateKeyType getKeyType() {
        return this.impl.getKeyProperties() == null ? null : this.impl.getKeyProperties().getKty();
    }

    public CertificatePolicy setKeyType(CertificateKeyType keyType) {
        if (this.impl.getKeyProperties() == null) {
            this.impl.setKeyProperties(new KeyProperties());
        }
        this.impl.getKeyProperties().setKty(keyType);
        return this;
    }

    public Integer getKeySize() {
        return this.impl.getKeyProperties() == null ? null : this.impl.getKeyProperties().getKeySize();
    }

    public Boolean isKeyReusable() {
        return this.impl.getKeyProperties() == null ? null : this.impl.getKeyProperties().isReuseKey();
    }

    public CertificatePolicy setKeyReusable(Boolean keyReusable) {
        if (this.impl.getKeyProperties() == null) {
            this.impl.setKeyProperties(new KeyProperties());
        }
        this.impl.getKeyProperties().setReuseKey(keyReusable);
        return this;
    }

    public CertificateKeyCurveName getKeyCurveName() {
        return this.impl.getKeyProperties() == null ? null : this.impl.getKeyProperties().getCrv();
    }

    public OffsetDateTime getCreatedOn() {
        return this.impl.getAttributes() == null ? null : this.impl.getAttributes().getCreated();
    }

    public OffsetDateTime getUpdatedOn() {
        return this.impl.getAttributes() == null ? null : this.impl.getAttributes().getUpdated();
    }

    public Boolean isEnabled() {
        return this.impl.getAttributes() == null ? null : this.impl.getAttributes().isEnabled();
    }

    public CertificatePolicy setEnabled(Boolean enabled) {
        if (this.impl.getAttributes() == null) {
            this.impl.setAttributes(new CertificateAttributes());
        }
        this.impl.getAttributes().setEnabled(enabled);
        return this;
    }

    public CertificateContentType getContentType() {
        return this.impl.getSecretProperties() == null ? null : CertificateContentType.fromString(this.impl.getSecretProperties().getContentType());
    }

    public CertificatePolicy setContentType(CertificateContentType contentType) {
        if (this.impl.getSecretProperties() == null) {
            this.impl.setSecretProperties(new SecretProperties());
        }
        this.impl.getSecretProperties().setContentType(Objects.toString((Object)contentType, null));
        return this;
    }

    public SubjectAlternativeNames getSubjectAlternativeNames() {
        return this.impl.getX509CertificateProperties().getSubjectAlternativeNames();
    }

    public CertificatePolicy setSubjectAlternativeNames(SubjectAlternativeNames subjectAlternativeNames) {
        this.impl.getX509CertificateProperties().setSubjectAlternativeNames(subjectAlternativeNames);
        return this;
    }

    public CertificatePolicy setSubject(String subject) {
        this.impl.getX509CertificateProperties().setSubject(subject);
        return this;
    }

    public CertificatePolicy setValidityInMonths(Integer validityInMonths) {
        this.impl.getX509CertificateProperties().setValidityInMonths(validityInMonths);
        return this;
    }

    public CertificatePolicy setKeySize(Integer keySize) {
        if (this.impl.getKeyProperties() == null) {
            this.impl.setKeyProperties(new KeyProperties());
        }
        this.impl.getKeyProperties().setKeySize(keySize);
        return this;
    }

    public CertificatePolicy setKeyCurveName(CertificateKeyCurveName keyCurveName) {
        if (this.impl.getKeyProperties() == null) {
            this.impl.setKeyProperties(new KeyProperties());
        }
        this.impl.getKeyProperties().setCrv(keyCurveName);
        return this;
    }

    public CertificatePolicy setCertificateType(String certificateType) {
        this.impl.getIssuerParameters().setCertificateType(certificateType);
        return this;
    }

    public CertificatePolicy setCertificateTransparent(Boolean certificateTransparent) {
        this.impl.getIssuerParameters().setCertificateTransparency(certificateTransparent);
        return this;
    }

    public String getSubject() {
        return this.impl.getX509CertificateProperties().getSubject();
    }

    public Integer getValidityInMonths() {
        return this.impl.getX509CertificateProperties().getValidityInMonths();
    }

    public String getIssuerName() {
        return this.impl.getIssuerParameters().getName();
    }

    public String getCertificateType() {
        return this.impl.getIssuerParameters().getCertificateType();
    }

    public Boolean isCertificateTransparent() {
        return this.impl.getIssuerParameters().isCertificateTransparency();
    }

    public CertificatePolicy setLifetimeActions(LifetimeAction ... actions) {
        if (actions == null) {
            this.impl.setLifetimeActions(null);
            this.lifetimeActions = null;
        } else {
            this.lifetimeActions = Arrays.asList(actions);
            ArrayList<com.azure.security.keyvault.certificates.implementation.models.LifetimeAction> implActions = new ArrayList<com.azure.security.keyvault.certificates.implementation.models.LifetimeAction>(actions.length);
            for (LifetimeAction action : actions) {
                implActions.add(action.getImpl());
            }
            this.impl.setLifetimeActions(implActions);
        }
        return this;
    }

    public List<LifetimeAction> getLifetimeActions() {
        if (this.lifetimeActions == null && this.impl.getLifetimeActions() != null) {
            this.lifetimeActions = new ArrayList<LifetimeAction>(this.impl.getLifetimeActions().size());
            for (com.azure.security.keyvault.certificates.implementation.models.LifetimeAction implAction : this.impl.getLifetimeActions()) {
                this.lifetimeActions.add(new LifetimeAction(implAction));
            }
        }
        return this.lifetimeActions;
    }

    public static CertificatePolicy getDefault() {
        return new CertificatePolicy("Self", "CN=DefaultPolicy");
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return this.impl.toJson(jsonWriter);
    }

    public static CertificatePolicy fromJson(JsonReader jsonReader) throws IOException {
        return new CertificatePolicy(com.azure.security.keyvault.certificates.implementation.models.CertificatePolicy.fromJson(jsonReader));
    }

    static {
        CertificatePolicyHelper.setAccessor(new CertificatePolicyHelper.CertificatePolicyAccessor(){

            @Override
            public CertificatePolicy createPolicy(com.azure.security.keyvault.certificates.implementation.models.CertificatePolicy impl) {
                return new CertificatePolicy(impl);
            }

            @Override
            public com.azure.security.keyvault.certificates.implementation.models.CertificatePolicy getPolicy(CertificatePolicy policy) {
                return policy == null ? null : policy.impl;
            }
        });
    }
}

