/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.secrets;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.polling.SyncPoller;
import com.azure.security.keyvault.secrets.SecretAsyncClient;
import com.azure.security.keyvault.secrets.SecretClientBuilder;
import com.azure.security.keyvault.secrets.SecretService;
import com.azure.security.keyvault.secrets.models.DeletedSecret;
import com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import com.azure.security.keyvault.secrets.models.SecretProperties;

@ServiceClient(builder=SecretClientBuilder.class, serviceInterfaces={SecretService.class})
public final class SecretClient {
    private final SecretAsyncClient client;

    public String getVaultUrl() {
        return this.client.getVaultUrl();
    }

    SecretClient(SecretAsyncClient client) {
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultSecret setSecret(KeyVaultSecret secret) {
        return (KeyVaultSecret)this.setSecretWithResponse(secret, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultSecret setSecret(String name, String value) {
        return (KeyVaultSecret)this.setSecretWithResponse(new KeyVaultSecret(name, value), Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultSecret> setSecretWithResponse(KeyVaultSecret secret, Context context) {
        return (Response)this.client.setSecretWithResponse(secret, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultSecret getSecret(String name, String version) {
        return (KeyVaultSecret)this.getSecretWithResponse(name, version, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultSecret getSecret(String name) {
        return (KeyVaultSecret)this.getSecretWithResponse(name, "", Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultSecret> getSecretWithResponse(String name, String version, Context context) {
        return (Response)this.client.getSecretWithResponse(name, version, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SecretProperties> updateSecretPropertiesWithResponse(SecretProperties secretProperties, Context context) {
        return (Response)this.client.updateSecretPropertiesWithResponse(secretProperties, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SecretProperties updateSecretProperties(SecretProperties secretProperties) {
        return (SecretProperties)this.updateSecretPropertiesWithResponse(secretProperties, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DeletedSecret, Void> beginDeleteSecret(String name) {
        return this.client.beginDeleteSecret(name).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeletedSecret getDeletedSecret(String name) {
        return (DeletedSecret)this.getDeletedSecretWithResponse(name, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DeletedSecret> getDeletedSecretWithResponse(String name, Context context) {
        return (Response)this.client.getDeletedSecretWithResponse(name, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void purgeDeletedSecret(String name) {
        this.purgeDeletedSecretWithResponse(name, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> purgeDeletedSecretWithResponse(String name, Context context) {
        return (Response)this.client.purgeDeletedSecretWithResponse(name, context).block();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<KeyVaultSecret, Void> beginRecoverDeletedSecret(String name) {
        return this.client.beginRecoverDeletedSecret(name).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public byte[] backupSecret(String name) {
        return (byte[])this.backupSecretWithResponse(name, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<byte[]> backupSecretWithResponse(String name, Context context) {
        return (Response)this.client.backupSecretWithResponse(name, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultSecret restoreSecretBackup(byte[] backup) {
        return (KeyVaultSecret)this.restoreSecretBackupWithResponse(backup, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultSecret> restoreSecretBackupWithResponse(byte[] backup, Context context) {
        return (Response)this.client.restoreSecretBackupWithResponse(backup, context).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SecretProperties> listPropertiesOfSecrets() {
        return this.listPropertiesOfSecrets(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SecretProperties> listPropertiesOfSecrets(Context context) {
        return new PagedIterable(this.client.listPropertiesOfSecrets(context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeletedSecret> listDeletedSecrets(Context context) {
        return new PagedIterable(this.client.listDeletedSecrets(context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeletedSecret> listDeletedSecrets() {
        return this.listDeletedSecrets(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SecretProperties> listPropertiesOfSecretVersions(String name) {
        return this.listPropertiesOfSecretVersions(name, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SecretProperties> listPropertiesOfSecretVersions(String name, Context context) {
        return new PagedIterable(this.client.listPropertiesOfSecretVersions(name, context));
    }
}

