/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.common;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.EmbeddedValueResolver;

public class ExpressionResolver {
    private static EmbeddedValueResolver embeddedValueResolver;

    public ExpressionResolver(BeanFactory beanFactory) {
        if (beanFactory instanceof ConfigurableBeanFactory) {
            ExpressionResolver.setEmbeddedValueResolver(new EmbeddedValueResolver((ConfigurableBeanFactory)beanFactory));
        }
    }

    public static String resolveExpression(String expression) {
        return embeddedValueResolver != null ? embeddedValueResolver.resolveStringValue(expression) : expression;
    }

    private static void setEmbeddedValueResolver(EmbeddedValueResolver embeddedValueResolver) {
        ExpressionResolver.embeddedValueResolver = embeddedValueResolver;
    }
}

