/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.credential.AzureSasCredential;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.specialized.BlockBlobAsyncClient;
import com.azure.storage.blob.specialized.SpecializedBlobClientBuilder;
import com.azure.storage.common.Utility;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.file.datalake.DataLakeFileAsyncClient;
import com.azure.storage.file.datalake.DataLakePathAsyncClient;
import com.azure.storage.file.datalake.DataLakePathClientBuilder;
import com.azure.storage.file.datalake.DataLakeServiceVersion;
import com.azure.storage.file.datalake.Transforms;
import com.azure.storage.file.datalake.implementation.models.FileSystemsListPathsHeaders;
import com.azure.storage.file.datalake.implementation.models.FileSystemsListPathsResponse;
import com.azure.storage.file.datalake.implementation.models.PathResourceType;
import com.azure.storage.file.datalake.implementation.util.DataLakeImplUtils;
import com.azure.storage.file.datalake.implementation.util.TransformUtils;
import com.azure.storage.file.datalake.models.DataLakeRequestConditions;
import com.azure.storage.file.datalake.models.PathHttpHeaders;
import com.azure.storage.file.datalake.models.PathItem;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

@ServiceClient(builder=DataLakePathClientBuilder.class, isAsync=true)
public final class DataLakeDirectoryAsyncClient
extends DataLakePathAsyncClient {
    private static final ClientLogger LOGGER = new ClientLogger(DataLakeDirectoryAsyncClient.class);

    DataLakeDirectoryAsyncClient(HttpPipeline pipeline, String url, DataLakeServiceVersion serviceVersion, String accountName, String fileSystemName, String directoryName, BlockBlobAsyncClient blockBlobAsyncClient, AzureSasCredential sasToken) {
        super(pipeline, url, serviceVersion, accountName, fileSystemName, directoryName, PathResourceType.DIRECTORY, blockBlobAsyncClient, sasToken);
    }

    DataLakeDirectoryAsyncClient(DataLakePathAsyncClient dataLakePathAsyncClient) {
        super(dataLakePathAsyncClient.getHttpPipeline(), dataLakePathAsyncClient.getAccountUrl(), dataLakePathAsyncClient.getServiceVersion(), dataLakePathAsyncClient.getAccountName(), dataLakePathAsyncClient.getFileSystemName(), Utility.urlEncode((String)dataLakePathAsyncClient.pathName), PathResourceType.DIRECTORY, dataLakePathAsyncClient.getBlockBlobAsyncClient(), dataLakePathAsyncClient.getSasToken());
    }

    public String getDirectoryUrl() {
        return this.getPathUrl();
    }

    public String getDirectoryPath() {
        return this.getObjectPath();
    }

    public String getDirectoryName() {
        return this.getObjectName();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> delete() {
        return this.deleteWithResponse(false, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponse(boolean recursive, DataLakeRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.deleteWithResponse(recursive, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    public DataLakeFileAsyncClient getFileAsyncClient(String fileName) {
        Objects.requireNonNull(fileName, "'fileName' can not be set to null");
        BlockBlobAsyncClient blockBlobAsyncClient = this.prepareBuilderAppendPath(fileName).buildBlockBlobAsyncClient();
        String pathPrefix = this.getObjectPath().isEmpty() ? "" : this.getObjectPath() + "/";
        return new DataLakeFileAsyncClient(this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getFileSystemName(), Utility.urlEncode((String)(pathPrefix + Utility.urlDecode((String)fileName))), blockBlobAsyncClient, this.getSasToken());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataLakeFileAsyncClient> createFile(String fileName) {
        return this.createFile(fileName, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataLakeFileAsyncClient> createFile(String fileName, boolean overwrite) {
        DataLakeRequestConditions requestConditions = new DataLakeRequestConditions();
        if (!overwrite) {
            requestConditions.setIfNoneMatch("*");
        }
        return this.createFileWithResponse(fileName, null, null, null, null, requestConditions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataLakeFileAsyncClient>> createFileWithResponse(String fileName, String permissions, String umask, PathHttpHeaders headers, Map<String, String> metadata, DataLakeRequestConditions requestConditions) {
        DataLakeFileAsyncClient dataLakeFileAsyncClient;
        try {
            dataLakeFileAsyncClient = this.getFileAsyncClient(fileName);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
        return dataLakeFileAsyncClient.createWithResponse(permissions, umask, headers, metadata, requestConditions).map(response -> new SimpleResponse(response, (Object)dataLakeFileAsyncClient));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteFile(String fileName) {
        return this.deleteFileWithResponse(fileName, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteFileWithResponse(String fileName, DataLakeRequestConditions requestConditions) {
        DataLakeFileAsyncClient dataLakeFileAsyncClient;
        try {
            dataLakeFileAsyncClient = this.getFileAsyncClient(fileName);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
        return dataLakeFileAsyncClient.deleteWithResponse(requestConditions);
    }

    public DataLakeDirectoryAsyncClient getSubdirectoryAsyncClient(String subdirectoryName) {
        Objects.requireNonNull(subdirectoryName, "'subdirectoryName' can not be set to null");
        BlockBlobAsyncClient blockBlobAsyncClient = this.prepareBuilderAppendPath(subdirectoryName).buildBlockBlobAsyncClient();
        String pathPrefix = this.getObjectPath().isEmpty() ? "" : this.getObjectPath() + "/";
        return new DataLakeDirectoryAsyncClient(this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getFileSystemName(), Utility.urlEncode((String)(pathPrefix + Utility.urlDecode((String)subdirectoryName))), blockBlobAsyncClient, this.getSasToken());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataLakeDirectoryAsyncClient> createSubdirectory(String subdirectoryName) {
        return this.createSubdirectory(subdirectoryName, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataLakeDirectoryAsyncClient> createSubdirectory(String subdirectoryName, boolean overwrite) {
        DataLakeRequestConditions requestConditions = new DataLakeRequestConditions();
        if (!overwrite) {
            requestConditions.setIfNoneMatch("*");
        }
        return this.createSubdirectoryWithResponse(subdirectoryName, null, null, null, null, requestConditions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataLakeDirectoryAsyncClient>> createSubdirectoryWithResponse(String subdirectoryName, String permissions, String umask, PathHttpHeaders headers, Map<String, String> metadata, DataLakeRequestConditions requestConditions) {
        DataLakeDirectoryAsyncClient dataLakeDirectoryAsyncClient;
        try {
            dataLakeDirectoryAsyncClient = this.getSubdirectoryAsyncClient(subdirectoryName);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
        return dataLakeDirectoryAsyncClient.createWithResponse(permissions, umask, headers, metadata, requestConditions).map(response -> new SimpleResponse(response, (Object)dataLakeDirectoryAsyncClient));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteSubdirectory(String subdirectoryName) {
        return this.deleteSubdirectoryWithResponse(subdirectoryName, false, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteSubdirectoryWithResponse(String directoryName, boolean recursive, DataLakeRequestConditions requestConditions) {
        DataLakeDirectoryAsyncClient dataLakeDirectoryAsyncClient;
        try {
            dataLakeDirectoryAsyncClient = this.getSubdirectoryAsyncClient(directoryName);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
        return dataLakeDirectoryAsyncClient.deleteWithResponse(recursive, requestConditions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataLakeDirectoryAsyncClient> rename(String destinationFileSystem, String destinationPath) {
        return this.renameWithResponse(destinationFileSystem, destinationPath, null, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataLakeDirectoryAsyncClient>> renameWithResponse(String destinationFileSystem, String destinationPath, DataLakeRequestConditions sourceRequestConditions, DataLakeRequestConditions destinationRequestConditions) {
        try {
            return FluxUtil.withContext(context -> this.renameWithResponse(destinationFileSystem, destinationPath, sourceRequestConditions, destinationRequestConditions, (Context)context)).map(response -> new SimpleResponse(response, (Object)new DataLakeDirectoryAsyncClient((DataLakePathAsyncClient)response.getValue())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PathItem> listPaths() {
        return this.listPaths(false, false, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PathItem> listPaths(boolean recursive, boolean userPrincipleNameReturned, Integer maxResults) {
        try {
            return this.listPathsWithOptionalTimeout(recursive, userPrincipleNameReturned, maxResults, null);
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    PagedFlux<PathItem> listPathsWithOptionalTimeout(boolean recursive, boolean userPrincipleNameReturned, Integer maxResults, Duration timeout) {
        BiFunction<String, Integer, Mono> func = (marker, pageSize) -> this.listPathsSegment((String)marker, recursive, userPrincipleNameReturned, pageSize == null ? maxResults : pageSize, timeout).map(response -> {
            List value = response.getValue() == null ? Collections.emptyList() : response.getValue().getPaths().stream().map(Transforms::toPathItem).collect(Collectors.toList());
            return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), value, ((FileSystemsListPathsHeaders)response.getDeserializedHeaders()).getXMsContinuation(), (Object)((FileSystemsListPathsHeaders)response.getDeserializedHeaders()));
        });
        return new PagedFlux(pageSize -> (Mono)func.apply((String)null, (Integer)pageSize), func);
    }

    private Mono<FileSystemsListPathsResponse> listPathsSegment(String marker, boolean recursive, boolean userPrincipleNameReturned, Integer maxResults, Duration timeout) {
        return StorageImplUtils.applyOptionalTimeout(this.fileSystemDataLakeStorage.getFileSystems().listPathsWithResponseAsync(recursive, null, null, marker, this.getDirectoryPath(), maxResults, userPrincipleNameReturned, Context.NONE), (Duration)timeout);
    }

    SpecializedBlobClientBuilder prepareBuilderAppendPath(String pathName) {
        String blobUrl = DataLakeImplUtils.endpointToDesiredEndpoint(this.getPathUrl(), "blob", "dfs");
        return new SpecializedBlobClientBuilder().pipeline(this.getHttpPipeline()).serviceVersion(TransformUtils.toBlobServiceVersion(this.getServiceVersion())).endpoint(StorageImplUtils.appendToUrlPath((String)blobUrl, (String)pathName).toString());
    }
}

