/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.resourcemanager.appcontainers.models.BuildConfiguration;
import com.azure.resourcemanager.appcontainers.models.BuildProvisioningState;
import com.azure.resourcemanager.appcontainers.models.BuildStatus;
import com.azure.resourcemanager.appcontainers.models.ContainerRegistryWithCustomImage;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class BuildProperties {
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private BuildProvisioningState provisioningState;
    @JsonProperty(value="buildStatus", access=JsonProperty.Access.WRITE_ONLY)
    private BuildStatus buildStatus;
    @JsonProperty(value="destinationContainerRegistry")
    private ContainerRegistryWithCustomImage destinationContainerRegistry;
    @JsonProperty(value="configuration")
    private BuildConfiguration configuration;
    @JsonProperty(value="uploadEndpoint", access=JsonProperty.Access.WRITE_ONLY)
    private String uploadEndpoint;
    @JsonProperty(value="logStreamEndpoint", access=JsonProperty.Access.WRITE_ONLY)
    private String logStreamEndpoint;
    @JsonProperty(value="tokenEndpoint", access=JsonProperty.Access.WRITE_ONLY)
    private String tokenEndpoint;

    public BuildProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public BuildStatus buildStatus() {
        return this.buildStatus;
    }

    public ContainerRegistryWithCustomImage destinationContainerRegistry() {
        return this.destinationContainerRegistry;
    }

    public BuildProperties withDestinationContainerRegistry(ContainerRegistryWithCustomImage destinationContainerRegistry) {
        this.destinationContainerRegistry = destinationContainerRegistry;
        return this;
    }

    public BuildConfiguration configuration() {
        return this.configuration;
    }

    public BuildProperties withConfiguration(BuildConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    public String uploadEndpoint() {
        return this.uploadEndpoint;
    }

    public String logStreamEndpoint() {
        return this.logStreamEndpoint;
    }

    public String tokenEndpoint() {
        return this.tokenEndpoint;
    }

    public void validate() {
        if (this.destinationContainerRegistry() != null) {
            this.destinationContainerRegistry().validate();
        }
        if (this.configuration() != null) {
            this.configuration().validate();
        }
    }
}

