/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.resourcemanager.appcontainers.fluent.models.BuilderProperties;
import com.azure.resourcemanager.appcontainers.models.BuilderProvisioningState;
import com.azure.resourcemanager.appcontainers.models.ContainerRegistry;
import com.azure.resourcemanager.appcontainers.models.ManagedServiceIdentity;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class BuilderResourceInner
extends Resource {
    @JsonProperty(value="properties")
    private BuilderProperties innerProperties;
    @JsonProperty(value="identity")
    private ManagedServiceIdentity identity;
    @JsonProperty(value="systemData", access=JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    private BuilderProperties innerProperties() {
        return this.innerProperties;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public BuilderResourceInner withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public BuilderResourceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public BuilderResourceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public BuilderProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String environmentId() {
        return this.innerProperties() == null ? null : this.innerProperties().environmentId();
    }

    public BuilderResourceInner withEnvironmentId(String environmentId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BuilderProperties();
        }
        this.innerProperties().withEnvironmentId(environmentId);
        return this;
    }

    public List<ContainerRegistry> containerRegistries() {
        return this.innerProperties() == null ? null : this.innerProperties().containerRegistries();
    }

    public BuilderResourceInner withContainerRegistries(List<ContainerRegistry> containerRegistries) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BuilderProperties();
        }
        this.innerProperties().withContainerRegistries(containerRegistries);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }
}

