/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.resourcemanager.appcontainers.models.Configuration;
import com.azure.resourcemanager.appcontainers.models.ContainerAppProvisioningState;
import com.azure.resourcemanager.appcontainers.models.Template;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class ContainerAppProperties {
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ContainerAppProvisioningState provisioningState;
    @JsonProperty(value="managedEnvironmentId")
    private String managedEnvironmentId;
    @JsonProperty(value="environmentId")
    private String environmentId;
    @JsonProperty(value="workloadProfileName")
    private String workloadProfileName;
    @JsonProperty(value="latestRevisionName", access=JsonProperty.Access.WRITE_ONLY)
    private String latestRevisionName;
    @JsonProperty(value="latestReadyRevisionName", access=JsonProperty.Access.WRITE_ONLY)
    private String latestReadyRevisionName;
    @JsonProperty(value="latestRevisionFqdn", access=JsonProperty.Access.WRITE_ONLY)
    private String latestRevisionFqdn;
    @JsonProperty(value="customDomainVerificationId", access=JsonProperty.Access.WRITE_ONLY)
    private String customDomainVerificationId;
    @JsonProperty(value="configuration")
    private Configuration configuration;
    @JsonProperty(value="template")
    private Template template;
    @JsonProperty(value="outboundIpAddresses", access=JsonProperty.Access.WRITE_ONLY)
    private List<String> outboundIpAddresses;
    @JsonProperty(value="eventStreamEndpoint", access=JsonProperty.Access.WRITE_ONLY)
    private String eventStreamEndpoint;

    public ContainerAppProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String managedEnvironmentId() {
        return this.managedEnvironmentId;
    }

    public ContainerAppProperties withManagedEnvironmentId(String managedEnvironmentId) {
        this.managedEnvironmentId = managedEnvironmentId;
        return this;
    }

    public String environmentId() {
        return this.environmentId;
    }

    public ContainerAppProperties withEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
        return this;
    }

    public String workloadProfileName() {
        return this.workloadProfileName;
    }

    public ContainerAppProperties withWorkloadProfileName(String workloadProfileName) {
        this.workloadProfileName = workloadProfileName;
        return this;
    }

    public String latestRevisionName() {
        return this.latestRevisionName;
    }

    public String latestReadyRevisionName() {
        return this.latestReadyRevisionName;
    }

    public String latestRevisionFqdn() {
        return this.latestRevisionFqdn;
    }

    public String customDomainVerificationId() {
        return this.customDomainVerificationId;
    }

    public Configuration configuration() {
        return this.configuration;
    }

    public ContainerAppProperties withConfiguration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public Template template() {
        return this.template;
    }

    public ContainerAppProperties withTemplate(Template template) {
        this.template = template;
        return this;
    }

    public List<String> outboundIpAddresses() {
        return this.outboundIpAddresses;
    }

    public String eventStreamEndpoint() {
        return this.eventStreamEndpoint;
    }

    public void validate() {
        if (this.configuration() != null) {
            this.configuration().validate();
        }
        if (this.template() != null) {
            this.template().validate();
        }
    }
}

