/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.resourcemanager.appcontainers.fluent.models.ManagedEnvironmentProperties;
import com.azure.resourcemanager.appcontainers.models.AppInsightsConfiguration;
import com.azure.resourcemanager.appcontainers.models.AppLogsConfiguration;
import com.azure.resourcemanager.appcontainers.models.CustomDomainConfiguration;
import com.azure.resourcemanager.appcontainers.models.DaprConfiguration;
import com.azure.resourcemanager.appcontainers.models.EnvironmentProvisioningState;
import com.azure.resourcemanager.appcontainers.models.KedaConfiguration;
import com.azure.resourcemanager.appcontainers.models.ManagedEnvironmentPropertiesPeerAuthentication;
import com.azure.resourcemanager.appcontainers.models.ManagedServiceIdentity;
import com.azure.resourcemanager.appcontainers.models.OpenTelemetryConfiguration;
import com.azure.resourcemanager.appcontainers.models.VnetConfiguration;
import com.azure.resourcemanager.appcontainers.models.WorkloadProfile;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class ManagedEnvironmentInner
extends Resource {
    @JsonProperty(value="kind")
    private String kind;
    @JsonProperty(value="identity")
    private ManagedServiceIdentity identity;
    @JsonProperty(value="properties")
    private ManagedEnvironmentProperties innerProperties;
    @JsonProperty(value="systemData", access=JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    public String kind() {
        return this.kind;
    }

    public ManagedEnvironmentInner withKind(String kind) {
        this.kind = kind;
        return this;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public ManagedEnvironmentInner withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    private ManagedEnvironmentProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public ManagedEnvironmentInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ManagedEnvironmentInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public EnvironmentProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String daprAIInstrumentationKey() {
        return this.innerProperties() == null ? null : this.innerProperties().daprAIInstrumentationKey();
    }

    public ManagedEnvironmentInner withDaprAIInstrumentationKey(String daprAIInstrumentationKey) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedEnvironmentProperties();
        }
        this.innerProperties().withDaprAIInstrumentationKey(daprAIInstrumentationKey);
        return this;
    }

    public String daprAIConnectionString() {
        return this.innerProperties() == null ? null : this.innerProperties().daprAIConnectionString();
    }

    public ManagedEnvironmentInner withDaprAIConnectionString(String daprAIConnectionString) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedEnvironmentProperties();
        }
        this.innerProperties().withDaprAIConnectionString(daprAIConnectionString);
        return this;
    }

    public VnetConfiguration vnetConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().vnetConfiguration();
    }

    public ManagedEnvironmentInner withVnetConfiguration(VnetConfiguration vnetConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedEnvironmentProperties();
        }
        this.innerProperties().withVnetConfiguration(vnetConfiguration);
        return this;
    }

    public String deploymentErrors() {
        return this.innerProperties() == null ? null : this.innerProperties().deploymentErrors();
    }

    public String defaultDomain() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultDomain();
    }

    public String staticIp() {
        return this.innerProperties() == null ? null : this.innerProperties().staticIp();
    }

    public AppLogsConfiguration appLogsConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().appLogsConfiguration();
    }

    public ManagedEnvironmentInner withAppLogsConfiguration(AppLogsConfiguration appLogsConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedEnvironmentProperties();
        }
        this.innerProperties().withAppLogsConfiguration(appLogsConfiguration);
        return this;
    }

    public AppInsightsConfiguration appInsightsConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().appInsightsConfiguration();
    }

    public ManagedEnvironmentInner withAppInsightsConfiguration(AppInsightsConfiguration appInsightsConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedEnvironmentProperties();
        }
        this.innerProperties().withAppInsightsConfiguration(appInsightsConfiguration);
        return this;
    }

    public OpenTelemetryConfiguration openTelemetryConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().openTelemetryConfiguration();
    }

    public ManagedEnvironmentInner withOpenTelemetryConfiguration(OpenTelemetryConfiguration openTelemetryConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedEnvironmentProperties();
        }
        this.innerProperties().withOpenTelemetryConfiguration(openTelemetryConfiguration);
        return this;
    }

    public Boolean zoneRedundant() {
        return this.innerProperties() == null ? null : this.innerProperties().zoneRedundant();
    }

    public ManagedEnvironmentInner withZoneRedundant(Boolean zoneRedundant) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedEnvironmentProperties();
        }
        this.innerProperties().withZoneRedundant(zoneRedundant);
        return this;
    }

    public CustomDomainConfiguration customDomainConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().customDomainConfiguration();
    }

    public ManagedEnvironmentInner withCustomDomainConfiguration(CustomDomainConfiguration customDomainConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedEnvironmentProperties();
        }
        this.innerProperties().withCustomDomainConfiguration(customDomainConfiguration);
        return this;
    }

    public String eventStreamEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().eventStreamEndpoint();
    }

    public List<WorkloadProfile> workloadProfiles() {
        return this.innerProperties() == null ? null : this.innerProperties().workloadProfiles();
    }

    public ManagedEnvironmentInner withWorkloadProfiles(List<WorkloadProfile> workloadProfiles) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedEnvironmentProperties();
        }
        this.innerProperties().withWorkloadProfiles(workloadProfiles);
        return this;
    }

    public KedaConfiguration kedaConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().kedaConfiguration();
    }

    public ManagedEnvironmentInner withKedaConfiguration(KedaConfiguration kedaConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedEnvironmentProperties();
        }
        this.innerProperties().withKedaConfiguration(kedaConfiguration);
        return this;
    }

    public DaprConfiguration daprConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().daprConfiguration();
    }

    public ManagedEnvironmentInner withDaprConfiguration(DaprConfiguration daprConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedEnvironmentProperties();
        }
        this.innerProperties().withDaprConfiguration(daprConfiguration);
        return this;
    }

    public String infrastructureResourceGroup() {
        return this.innerProperties() == null ? null : this.innerProperties().infrastructureResourceGroup();
    }

    public ManagedEnvironmentInner withInfrastructureResourceGroup(String infrastructureResourceGroup) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedEnvironmentProperties();
        }
        this.innerProperties().withInfrastructureResourceGroup(infrastructureResourceGroup);
        return this;
    }

    public ManagedEnvironmentPropertiesPeerAuthentication peerAuthentication() {
        return this.innerProperties() == null ? null : this.innerProperties().peerAuthentication();
    }

    public ManagedEnvironmentInner withPeerAuthentication(ManagedEnvironmentPropertiesPeerAuthentication peerAuthentication) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedEnvironmentProperties();
        }
        this.innerProperties().withPeerAuthentication(peerAuthentication);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

