/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.resourcemanager.appcontainers.models.ContainerAppReplicaRunningState;
import com.azure.resourcemanager.appcontainers.models.ReplicaContainer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public final class ReplicaProperties {
    @JsonProperty(value="createdTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime createdTime;
    @JsonProperty(value="runningState", access=JsonProperty.Access.WRITE_ONLY)
    private ContainerAppReplicaRunningState runningState;
    @JsonProperty(value="runningStateDetails", access=JsonProperty.Access.WRITE_ONLY)
    private String runningStateDetails;
    @JsonProperty(value="containers")
    private List<ReplicaContainer> containers;
    @JsonProperty(value="initContainers")
    private List<ReplicaContainer> initContainers;

    public OffsetDateTime createdTime() {
        return this.createdTime;
    }

    public ContainerAppReplicaRunningState runningState() {
        return this.runningState;
    }

    public String runningStateDetails() {
        return this.runningStateDetails;
    }

    public List<ReplicaContainer> containers() {
        return this.containers;
    }

    public ReplicaProperties withContainers(List<ReplicaContainer> containers) {
        this.containers = containers;
        return this;
    }

    public List<ReplicaContainer> initContainers() {
        return this.initContainers;
    }

    public ReplicaProperties withInitContainers(List<ReplicaContainer> initContainers) {
        this.initContainers = initContainers;
        return this;
    }

    public void validate() {
        if (this.containers() != null) {
            this.containers().forEach(e -> e.validate());
        }
        if (this.initContainers() != null) {
            this.initContainers().forEach(e -> e.validate());
        }
    }
}

