/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.models.AppResiliencyInner;
import com.azure.resourcemanager.appcontainers.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appcontainers.models.AppResiliency;
import com.azure.resourcemanager.appcontainers.models.CircuitBreakerPolicy;
import com.azure.resourcemanager.appcontainers.models.HttpConnectionPool;
import com.azure.resourcemanager.appcontainers.models.HttpRetryPolicy;
import com.azure.resourcemanager.appcontainers.models.TcpConnectionPool;
import com.azure.resourcemanager.appcontainers.models.TcpRetryPolicy;
import com.azure.resourcemanager.appcontainers.models.TimeoutPolicy;

public final class AppResiliencyImpl
implements AppResiliency,
AppResiliency.Definition,
AppResiliency.Update {
    private AppResiliencyInner innerObject;
    private final ContainerAppsApiManager serviceManager;
    private String resourceGroupName;
    private String appName;
    private String name;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public TimeoutPolicy timeoutPolicy() {
        return this.innerModel().timeoutPolicy();
    }

    @Override
    public HttpRetryPolicy httpRetryPolicy() {
        return this.innerModel().httpRetryPolicy();
    }

    @Override
    public TcpRetryPolicy tcpRetryPolicy() {
        return this.innerModel().tcpRetryPolicy();
    }

    @Override
    public CircuitBreakerPolicy circuitBreakerPolicy() {
        return this.innerModel().circuitBreakerPolicy();
    }

    @Override
    public HttpConnectionPool httpConnectionPool() {
        return this.innerModel().httpConnectionPool();
    }

    @Override
    public TcpConnectionPool tcpConnectionPool() {
        return this.innerModel().tcpConnectionPool();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public AppResiliencyInner innerModel() {
        return this.innerObject;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    @Override
    public AppResiliencyImpl withExistingContainerApp(String resourceGroupName, String appName) {
        this.resourceGroupName = resourceGroupName;
        this.appName = appName;
        return this;
    }

    @Override
    public AppResiliency create() {
        this.innerObject = (AppResiliencyInner)((Object)this.serviceManager.serviceClient().getAppResiliencies().createOrUpdateWithResponse(this.resourceGroupName, this.appName, this.name, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public AppResiliency create(Context context) {
        this.innerObject = (AppResiliencyInner)((Object)this.serviceManager.serviceClient().getAppResiliencies().createOrUpdateWithResponse(this.resourceGroupName, this.appName, this.name, this.innerModel(), context).getValue());
        return this;
    }

    AppResiliencyImpl(String name, ContainerAppsApiManager serviceManager) {
        this.innerObject = new AppResiliencyInner();
        this.serviceManager = serviceManager;
        this.name = name;
    }

    @Override
    public AppResiliencyImpl update() {
        return this;
    }

    @Override
    public AppResiliency apply() {
        this.innerObject = (AppResiliencyInner)((Object)this.serviceManager.serviceClient().getAppResiliencies().updateWithResponse(this.resourceGroupName, this.appName, this.name, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public AppResiliency apply(Context context) {
        this.innerObject = (AppResiliencyInner)((Object)this.serviceManager.serviceClient().getAppResiliencies().updateWithResponse(this.resourceGroupName, this.appName, this.name, this.innerModel(), context).getValue());
        return this;
    }

    AppResiliencyImpl(AppResiliencyInner innerObject, ContainerAppsApiManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.appName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "containerApps");
        this.name = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resiliencyPolicies");
    }

    @Override
    public AppResiliency refresh() {
        this.innerObject = (AppResiliencyInner)((Object)this.serviceManager.serviceClient().getAppResiliencies().getWithResponse(this.resourceGroupName, this.appName, this.name, Context.NONE).getValue());
        return this;
    }

    @Override
    public AppResiliency refresh(Context context) {
        this.innerObject = (AppResiliencyInner)((Object)this.serviceManager.serviceClient().getAppResiliencies().getWithResponse(this.resourceGroupName, this.appName, this.name, context).getValue());
        return this;
    }

    @Override
    public AppResiliencyImpl withTimeoutPolicy(TimeoutPolicy timeoutPolicy) {
        this.innerModel().withTimeoutPolicy(timeoutPolicy);
        return this;
    }

    @Override
    public AppResiliencyImpl withHttpRetryPolicy(HttpRetryPolicy httpRetryPolicy) {
        this.innerModel().withHttpRetryPolicy(httpRetryPolicy);
        return this;
    }

    @Override
    public AppResiliencyImpl withTcpRetryPolicy(TcpRetryPolicy tcpRetryPolicy) {
        this.innerModel().withTcpRetryPolicy(tcpRetryPolicy);
        return this;
    }

    @Override
    public AppResiliencyImpl withCircuitBreakerPolicy(CircuitBreakerPolicy circuitBreakerPolicy) {
        this.innerModel().withCircuitBreakerPolicy(circuitBreakerPolicy);
        return this;
    }

    @Override
    public AppResiliencyImpl withHttpConnectionPool(HttpConnectionPool httpConnectionPool) {
        this.innerModel().withHttpConnectionPool(httpConnectionPool);
        return this;
    }

    @Override
    public AppResiliencyImpl withTcpConnectionPool(TcpConnectionPool tcpConnectionPool) {
        this.innerModel().withTcpConnectionPool(tcpConnectionPool);
        return this;
    }
}

