/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.models.AuthConfigInner;
import com.azure.resourcemanager.appcontainers.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appcontainers.models.AuthConfig;
import com.azure.resourcemanager.appcontainers.models.AuthPlatform;
import com.azure.resourcemanager.appcontainers.models.EncryptionSettings;
import com.azure.resourcemanager.appcontainers.models.GlobalValidation;
import com.azure.resourcemanager.appcontainers.models.HttpSettings;
import com.azure.resourcemanager.appcontainers.models.IdentityProviders;
import com.azure.resourcemanager.appcontainers.models.Login;

public final class AuthConfigImpl
implements AuthConfig,
AuthConfig.Definition,
AuthConfig.Update {
    private AuthConfigInner innerObject;
    private final ContainerAppsApiManager serviceManager;
    private String resourceGroupName;
    private String containerAppName;
    private String authConfigName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public AuthPlatform platform() {
        return this.innerModel().platform();
    }

    @Override
    public GlobalValidation globalValidation() {
        return this.innerModel().globalValidation();
    }

    @Override
    public IdentityProviders identityProviders() {
        return this.innerModel().identityProviders();
    }

    @Override
    public Login login() {
        return this.innerModel().login();
    }

    @Override
    public HttpSettings httpSettings() {
        return this.innerModel().httpSettings();
    }

    @Override
    public EncryptionSettings encryptionSettings() {
        return this.innerModel().encryptionSettings();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public AuthConfigInner innerModel() {
        return this.innerObject;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    @Override
    public AuthConfigImpl withExistingContainerApp(String resourceGroupName, String containerAppName) {
        this.resourceGroupName = resourceGroupName;
        this.containerAppName = containerAppName;
        return this;
    }

    @Override
    public AuthConfig create() {
        this.innerObject = (AuthConfigInner)((Object)this.serviceManager.serviceClient().getContainerAppsAuthConfigs().createOrUpdateWithResponse(this.resourceGroupName, this.containerAppName, this.authConfigName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public AuthConfig create(Context context) {
        this.innerObject = (AuthConfigInner)((Object)this.serviceManager.serviceClient().getContainerAppsAuthConfigs().createOrUpdateWithResponse(this.resourceGroupName, this.containerAppName, this.authConfigName, this.innerModel(), context).getValue());
        return this;
    }

    AuthConfigImpl(String name, ContainerAppsApiManager serviceManager) {
        this.innerObject = new AuthConfigInner();
        this.serviceManager = serviceManager;
        this.authConfigName = name;
    }

    @Override
    public AuthConfigImpl update() {
        return this;
    }

    @Override
    public AuthConfig apply() {
        this.innerObject = (AuthConfigInner)((Object)this.serviceManager.serviceClient().getContainerAppsAuthConfigs().createOrUpdateWithResponse(this.resourceGroupName, this.containerAppName, this.authConfigName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public AuthConfig apply(Context context) {
        this.innerObject = (AuthConfigInner)((Object)this.serviceManager.serviceClient().getContainerAppsAuthConfigs().createOrUpdateWithResponse(this.resourceGroupName, this.containerAppName, this.authConfigName, this.innerModel(), context).getValue());
        return this;
    }

    AuthConfigImpl(AuthConfigInner innerObject, ContainerAppsApiManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.containerAppName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "containerApps");
        this.authConfigName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "authConfigs");
    }

    @Override
    public AuthConfig refresh() {
        this.innerObject = (AuthConfigInner)((Object)this.serviceManager.serviceClient().getContainerAppsAuthConfigs().getWithResponse(this.resourceGroupName, this.containerAppName, this.authConfigName, Context.NONE).getValue());
        return this;
    }

    @Override
    public AuthConfig refresh(Context context) {
        this.innerObject = (AuthConfigInner)((Object)this.serviceManager.serviceClient().getContainerAppsAuthConfigs().getWithResponse(this.resourceGroupName, this.containerAppName, this.authConfigName, context).getValue());
        return this;
    }

    @Override
    public AuthConfigImpl withPlatform(AuthPlatform platform) {
        this.innerModel().withPlatform(platform);
        return this;
    }

    @Override
    public AuthConfigImpl withGlobalValidation(GlobalValidation globalValidation) {
        this.innerModel().withGlobalValidation(globalValidation);
        return this;
    }

    @Override
    public AuthConfigImpl withIdentityProviders(IdentityProviders identityProviders) {
        this.innerModel().withIdentityProviders(identityProviders);
        return this;
    }

    @Override
    public AuthConfigImpl withLogin(Login login) {
        this.innerModel().withLogin(login);
        return this;
    }

    @Override
    public AuthConfigImpl withHttpSettings(HttpSettings httpSettings) {
        this.innerModel().withHttpSettings(httpSettings);
        return this;
    }

    @Override
    public AuthConfigImpl withEncryptionSettings(EncryptionSettings encryptionSettings) {
        this.innerModel().withEncryptionSettings(encryptionSettings);
        return this;
    }
}

