/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.models.ConnectedEnvironmentStorageInner;
import com.azure.resourcemanager.appcontainers.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appcontainers.models.ConnectedEnvironmentStorage;
import com.azure.resourcemanager.appcontainers.models.ConnectedEnvironmentStorageProperties;

public final class ConnectedEnvironmentStorageImpl
implements ConnectedEnvironmentStorage,
ConnectedEnvironmentStorage.Definition,
ConnectedEnvironmentStorage.Update {
    private ConnectedEnvironmentStorageInner innerObject;
    private final ContainerAppsApiManager serviceManager;
    private String resourceGroupName;
    private String connectedEnvironmentName;
    private String storageName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public ConnectedEnvironmentStorageProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ConnectedEnvironmentStorageInner innerModel() {
        return this.innerObject;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    @Override
    public ConnectedEnvironmentStorageImpl withExistingConnectedEnvironment(String resourceGroupName, String connectedEnvironmentName) {
        this.resourceGroupName = resourceGroupName;
        this.connectedEnvironmentName = connectedEnvironmentName;
        return this;
    }

    @Override
    public ConnectedEnvironmentStorage create() {
        this.innerObject = (ConnectedEnvironmentStorageInner)((Object)this.serviceManager.serviceClient().getConnectedEnvironmentsStorages().createOrUpdateWithResponse(this.resourceGroupName, this.connectedEnvironmentName, this.storageName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public ConnectedEnvironmentStorage create(Context context) {
        this.innerObject = (ConnectedEnvironmentStorageInner)((Object)this.serviceManager.serviceClient().getConnectedEnvironmentsStorages().createOrUpdateWithResponse(this.resourceGroupName, this.connectedEnvironmentName, this.storageName, this.innerModel(), context).getValue());
        return this;
    }

    ConnectedEnvironmentStorageImpl(String name, ContainerAppsApiManager serviceManager) {
        this.innerObject = new ConnectedEnvironmentStorageInner();
        this.serviceManager = serviceManager;
        this.storageName = name;
    }

    @Override
    public ConnectedEnvironmentStorageImpl update() {
        return this;
    }

    @Override
    public ConnectedEnvironmentStorage apply() {
        this.innerObject = (ConnectedEnvironmentStorageInner)((Object)this.serviceManager.serviceClient().getConnectedEnvironmentsStorages().createOrUpdateWithResponse(this.resourceGroupName, this.connectedEnvironmentName, this.storageName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public ConnectedEnvironmentStorage apply(Context context) {
        this.innerObject = (ConnectedEnvironmentStorageInner)((Object)this.serviceManager.serviceClient().getConnectedEnvironmentsStorages().createOrUpdateWithResponse(this.resourceGroupName, this.connectedEnvironmentName, this.storageName, this.innerModel(), context).getValue());
        return this;
    }

    ConnectedEnvironmentStorageImpl(ConnectedEnvironmentStorageInner innerObject, ContainerAppsApiManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.connectedEnvironmentName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "connectedEnvironments");
        this.storageName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "storages");
    }

    @Override
    public ConnectedEnvironmentStorage refresh() {
        this.innerObject = (ConnectedEnvironmentStorageInner)((Object)this.serviceManager.serviceClient().getConnectedEnvironmentsStorages().getWithResponse(this.resourceGroupName, this.connectedEnvironmentName, this.storageName, Context.NONE).getValue());
        return this;
    }

    @Override
    public ConnectedEnvironmentStorage refresh(Context context) {
        this.innerObject = (ConnectedEnvironmentStorageInner)((Object)this.serviceManager.serviceClient().getConnectedEnvironmentsStorages().getWithResponse(this.resourceGroupName, this.connectedEnvironmentName, this.storageName, context).getValue());
        return this;
    }

    @Override
    public ConnectedEnvironmentStorageImpl withProperties(ConnectedEnvironmentStorageProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

