/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.ContainerAppsDiagnosticsClient;
import com.azure.resourcemanager.appcontainers.fluent.models.ContainerAppInner;
import com.azure.resourcemanager.appcontainers.fluent.models.DiagnosticsInner;
import com.azure.resourcemanager.appcontainers.fluent.models.RevisionInner;
import com.azure.resourcemanager.appcontainers.implementation.ContainerAppImpl;
import com.azure.resourcemanager.appcontainers.implementation.DiagnosticsImpl;
import com.azure.resourcemanager.appcontainers.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appcontainers.implementation.RevisionImpl;
import com.azure.resourcemanager.appcontainers.models.ContainerApp;
import com.azure.resourcemanager.appcontainers.models.ContainerAppsDiagnostics;
import com.azure.resourcemanager.appcontainers.models.Diagnostics;
import com.azure.resourcemanager.appcontainers.models.Revision;

public final class ContainerAppsDiagnosticsImpl
implements ContainerAppsDiagnostics {
    private static final ClientLogger LOGGER = new ClientLogger(ContainerAppsDiagnosticsImpl.class);
    private final ContainerAppsDiagnosticsClient innerClient;
    private final ContainerAppsApiManager serviceManager;

    public ContainerAppsDiagnosticsImpl(ContainerAppsDiagnosticsClient innerClient, ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Diagnostics> listDetectors(String resourceGroupName, String containerAppName) {
        PagedIterable<DiagnosticsInner> inner = this.serviceClient().listDetectors(resourceGroupName, containerAppName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DiagnosticsImpl((DiagnosticsInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Diagnostics> listDetectors(String resourceGroupName, String containerAppName, Context context) {
        PagedIterable<DiagnosticsInner> inner = this.serviceClient().listDetectors(resourceGroupName, containerAppName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DiagnosticsImpl((DiagnosticsInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<Diagnostics> getDetectorWithResponse(String resourceGroupName, String containerAppName, String detectorName, Context context) {
        Response<DiagnosticsInner> inner = this.serviceClient().getDetectorWithResponse(resourceGroupName, containerAppName, detectorName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DiagnosticsImpl((DiagnosticsInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Diagnostics getDetector(String resourceGroupName, String containerAppName, String detectorName) {
        DiagnosticsInner inner = this.serviceClient().getDetector(resourceGroupName, containerAppName, detectorName);
        if (inner != null) {
            return new DiagnosticsImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<Revision> listRevisions(String resourceGroupName, String containerAppName) {
        PagedIterable<RevisionInner> inner = this.serviceClient().listRevisions(resourceGroupName, containerAppName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new RevisionImpl((RevisionInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Revision> listRevisions(String resourceGroupName, String containerAppName, String filter, Context context) {
        PagedIterable<RevisionInner> inner = this.serviceClient().listRevisions(resourceGroupName, containerAppName, filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new RevisionImpl((RevisionInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<Revision> getRevisionWithResponse(String resourceGroupName, String containerAppName, String revisionName, Context context) {
        Response<RevisionInner> inner = this.serviceClient().getRevisionWithResponse(resourceGroupName, containerAppName, revisionName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new RevisionImpl((RevisionInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Revision getRevision(String resourceGroupName, String containerAppName, String revisionName) {
        RevisionInner inner = this.serviceClient().getRevision(resourceGroupName, containerAppName, revisionName);
        if (inner != null) {
            return new RevisionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ContainerApp> getRootWithResponse(String resourceGroupName, String containerAppName, Context context) {
        Response<ContainerAppInner> inner = this.serviceClient().getRootWithResponse(resourceGroupName, containerAppName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ContainerAppImpl((ContainerAppInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ContainerApp getRoot(String resourceGroupName, String containerAppName) {
        ContainerAppInner inner = this.serviceClient().getRoot(resourceGroupName, containerAppName);
        if (inner != null) {
            return new ContainerAppImpl(inner, this.manager());
        }
        return null;
    }

    private ContainerAppsDiagnosticsClient serviceClient() {
        return this.innerClient;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }
}

