/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.ContainerAppsRevisionsClient;
import com.azure.resourcemanager.appcontainers.fluent.models.RevisionInner;
import com.azure.resourcemanager.appcontainers.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appcontainers.implementation.RevisionImpl;
import com.azure.resourcemanager.appcontainers.models.ContainerAppsRevisions;
import com.azure.resourcemanager.appcontainers.models.Revision;

public final class ContainerAppsRevisionsImpl
implements ContainerAppsRevisions {
    private static final ClientLogger LOGGER = new ClientLogger(ContainerAppsRevisionsImpl.class);
    private final ContainerAppsRevisionsClient innerClient;
    private final ContainerAppsApiManager serviceManager;

    public ContainerAppsRevisionsImpl(ContainerAppsRevisionsClient innerClient, ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Revision> listRevisions(String resourceGroupName, String containerAppName) {
        PagedIterable<RevisionInner> inner = this.serviceClient().listRevisions(resourceGroupName, containerAppName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new RevisionImpl((RevisionInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Revision> listRevisions(String resourceGroupName, String containerAppName, String filter, Context context) {
        PagedIterable<RevisionInner> inner = this.serviceClient().listRevisions(resourceGroupName, containerAppName, filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new RevisionImpl((RevisionInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<Revision> getRevisionWithResponse(String resourceGroupName, String containerAppName, String revisionName, Context context) {
        Response<RevisionInner> inner = this.serviceClient().getRevisionWithResponse(resourceGroupName, containerAppName, revisionName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new RevisionImpl((RevisionInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Revision getRevision(String resourceGroupName, String containerAppName, String revisionName) {
        RevisionInner inner = this.serviceClient().getRevision(resourceGroupName, containerAppName, revisionName);
        if (inner != null) {
            return new RevisionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> activateRevisionWithResponse(String resourceGroupName, String containerAppName, String revisionName, Context context) {
        return this.serviceClient().activateRevisionWithResponse(resourceGroupName, containerAppName, revisionName, context);
    }

    @Override
    public void activateRevision(String resourceGroupName, String containerAppName, String revisionName) {
        this.serviceClient().activateRevision(resourceGroupName, containerAppName, revisionName);
    }

    @Override
    public Response<Void> deactivateRevisionWithResponse(String resourceGroupName, String containerAppName, String revisionName, Context context) {
        return this.serviceClient().deactivateRevisionWithResponse(resourceGroupName, containerAppName, revisionName, context);
    }

    @Override
    public void deactivateRevision(String resourceGroupName, String containerAppName, String revisionName) {
        this.serviceClient().deactivateRevision(resourceGroupName, containerAppName, revisionName);
    }

    @Override
    public Response<Void> restartRevisionWithResponse(String resourceGroupName, String containerAppName, String revisionName, Context context) {
        return this.serviceClient().restartRevisionWithResponse(resourceGroupName, containerAppName, revisionName, context);
    }

    @Override
    public void restartRevision(String resourceGroupName, String containerAppName, String revisionName) {
        this.serviceClient().restartRevision(resourceGroupName, containerAppName, revisionName);
    }

    private ContainerAppsRevisionsClient serviceClient() {
        return this.innerClient;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }
}

