/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.DaprSubscriptionsClient;
import com.azure.resourcemanager.appcontainers.fluent.models.DaprSubscriptionInner;
import com.azure.resourcemanager.appcontainers.implementation.DaprSubscriptionImpl;
import com.azure.resourcemanager.appcontainers.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appcontainers.models.DaprSubscription;
import com.azure.resourcemanager.appcontainers.models.DaprSubscriptions;

public final class DaprSubscriptionsImpl
implements DaprSubscriptions {
    private static final ClientLogger LOGGER = new ClientLogger(DaprSubscriptionsImpl.class);
    private final DaprSubscriptionsClient innerClient;
    private final ContainerAppsApiManager serviceManager;

    public DaprSubscriptionsImpl(DaprSubscriptionsClient innerClient, ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<DaprSubscription> list(String resourceGroupName, String environmentName) {
        PagedIterable<DaprSubscriptionInner> inner = this.serviceClient().list(resourceGroupName, environmentName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DaprSubscriptionImpl((DaprSubscriptionInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DaprSubscription> list(String resourceGroupName, String environmentName, Context context) {
        PagedIterable<DaprSubscriptionInner> inner = this.serviceClient().list(resourceGroupName, environmentName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DaprSubscriptionImpl((DaprSubscriptionInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<DaprSubscription> getWithResponse(String resourceGroupName, String environmentName, String name, Context context) {
        Response<DaprSubscriptionInner> inner = this.serviceClient().getWithResponse(resourceGroupName, environmentName, name, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DaprSubscriptionImpl((DaprSubscriptionInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public DaprSubscription get(String resourceGroupName, String environmentName, String name) {
        DaprSubscriptionInner inner = this.serviceClient().get(resourceGroupName, environmentName, name);
        if (inner != null) {
            return new DaprSubscriptionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String environmentName, String name, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, environmentName, name, context);
    }

    @Override
    public void delete(String resourceGroupName, String environmentName, String name) {
        this.serviceClient().delete(resourceGroupName, environmentName, name);
    }

    @Override
    public DaprSubscription getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = ResourceManagerUtils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        String name = ResourceManagerUtils.getValueFromIdByName(id, "daprSubscriptions");
        if (name == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'daprSubscriptions'.", id)));
        }
        return (DaprSubscription)this.getWithResponse(resourceGroupName, environmentName, name, Context.NONE).getValue();
    }

    @Override
    public Response<DaprSubscription> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = ResourceManagerUtils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        String name = ResourceManagerUtils.getValueFromIdByName(id, "daprSubscriptions");
        if (name == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'daprSubscriptions'.", id)));
        }
        return this.getWithResponse(resourceGroupName, environmentName, name, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = ResourceManagerUtils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        String name = ResourceManagerUtils.getValueFromIdByName(id, "daprSubscriptions");
        if (name == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'daprSubscriptions'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, environmentName, name, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = ResourceManagerUtils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        String name = ResourceManagerUtils.getValueFromIdByName(id, "daprSubscriptions");
        if (name == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'daprSubscriptions'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, environmentName, name, context);
    }

    private DaprSubscriptionsClient serviceClient() {
        return this.innerClient;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    @Override
    public DaprSubscriptionImpl define(String name) {
        return new DaprSubscriptionImpl(name, this.manager());
    }
}

