/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.resourcemanager.appcontainers.models.ContainerResources;
import com.azure.resourcemanager.appcontainers.models.EnvironmentVar;
import com.azure.resourcemanager.appcontainers.models.VolumeMount;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class BaseContainer {
    @JsonProperty(value="image")
    private String image;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="command")
    private List<String> command;
    @JsonProperty(value="args")
    private List<String> args;
    @JsonProperty(value="env")
    private List<EnvironmentVar> env;
    @JsonProperty(value="resources")
    private ContainerResources resources;
    @JsonProperty(value="volumeMounts")
    private List<VolumeMount> volumeMounts;

    public String image() {
        return this.image;
    }

    public BaseContainer withImage(String image) {
        this.image = image;
        return this;
    }

    public String name() {
        return this.name;
    }

    public BaseContainer withName(String name) {
        this.name = name;
        return this;
    }

    public List<String> command() {
        return this.command;
    }

    public BaseContainer withCommand(List<String> command) {
        this.command = command;
        return this;
    }

    public List<String> args() {
        return this.args;
    }

    public BaseContainer withArgs(List<String> args) {
        this.args = args;
        return this;
    }

    public List<EnvironmentVar> env() {
        return this.env;
    }

    public BaseContainer withEnv(List<EnvironmentVar> env) {
        this.env = env;
        return this;
    }

    public ContainerResources resources() {
        return this.resources;
    }

    public BaseContainer withResources(ContainerResources resources) {
        this.resources = resources;
        return this;
    }

    public List<VolumeMount> volumeMounts() {
        return this.volumeMounts;
    }

    public BaseContainer withVolumeMounts(List<VolumeMount> volumeMounts) {
        this.volumeMounts = volumeMounts;
        return this;
    }

    public void validate() {
        if (this.env() != null) {
            this.env().forEach(e -> e.validate());
        }
        if (this.resources() != null) {
            this.resources().validate();
        }
        if (this.volumeMounts() != null) {
            this.volumeMounts().forEach(e -> e.validate());
        }
    }
}

