/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.resourcemanager.appcontainers.fluent.models.BuilderResourceUpdateProperties;
import com.azure.resourcemanager.appcontainers.models.ManagedServiceIdentity;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class BuilderResourceUpdate {
    @JsonProperty(value="identity")
    private ManagedServiceIdentity identity;
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> tags;
    @JsonProperty(value="properties")
    private BuilderResourceUpdateProperties innerProperties;

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public BuilderResourceUpdate withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public BuilderResourceUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    private BuilderResourceUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public String environmentId() {
        return this.innerProperties() == null ? null : this.innerProperties().environmentId();
    }

    public BuilderResourceUpdate withEnvironmentId(String environmentId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BuilderResourceUpdateProperties();
        }
        this.innerProperties().withEnvironmentId(environmentId);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

