/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class CorsPolicy {
    @JsonProperty(value="allowedOrigins", required=true)
    private List<String> allowedOrigins;
    @JsonProperty(value="allowedMethods")
    private List<String> allowedMethods;
    @JsonProperty(value="allowedHeaders")
    private List<String> allowedHeaders;
    @JsonProperty(value="exposeHeaders")
    private List<String> exposeHeaders;
    @JsonProperty(value="maxAge")
    private Integer maxAge;
    @JsonProperty(value="allowCredentials")
    private Boolean allowCredentials;
    private static final ClientLogger LOGGER = new ClientLogger(CorsPolicy.class);

    public List<String> allowedOrigins() {
        return this.allowedOrigins;
    }

    public CorsPolicy withAllowedOrigins(List<String> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
        return this;
    }

    public List<String> allowedMethods() {
        return this.allowedMethods;
    }

    public CorsPolicy withAllowedMethods(List<String> allowedMethods) {
        this.allowedMethods = allowedMethods;
        return this;
    }

    public List<String> allowedHeaders() {
        return this.allowedHeaders;
    }

    public CorsPolicy withAllowedHeaders(List<String> allowedHeaders) {
        this.allowedHeaders = allowedHeaders;
        return this;
    }

    public List<String> exposeHeaders() {
        return this.exposeHeaders;
    }

    public CorsPolicy withExposeHeaders(List<String> exposeHeaders) {
        this.exposeHeaders = exposeHeaders;
        return this;
    }

    public Integer maxAge() {
        return this.maxAge;
    }

    public CorsPolicy withMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
        return this;
    }

    public Boolean allowCredentials() {
        return this.allowCredentials;
    }

    public CorsPolicy withAllowCredentials(Boolean allowCredentials) {
        this.allowCredentials = allowCredentials;
        return this;
    }

    public void validate() {
        if (this.allowedOrigins() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property allowedOrigins in model CorsPolicy"));
        }
    }
}

