/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.resourcemanager.appcontainers.models.SecretVolumeItem;
import com.azure.resourcemanager.appcontainers.models.StorageType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class Volume {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="storageType")
    private StorageType storageType;
    @JsonProperty(value="storageName")
    private String storageName;
    @JsonProperty(value="secrets")
    private List<SecretVolumeItem> secrets;
    @JsonProperty(value="mountOptions")
    private String mountOptions;

    public String name() {
        return this.name;
    }

    public Volume withName(String name) {
        this.name = name;
        return this;
    }

    public StorageType storageType() {
        return this.storageType;
    }

    public Volume withStorageType(StorageType storageType) {
        this.storageType = storageType;
        return this;
    }

    public String storageName() {
        return this.storageName;
    }

    public Volume withStorageName(String storageName) {
        this.storageName = storageName;
        return this;
    }

    public List<SecretVolumeItem> secrets() {
        return this.secrets;
    }

    public Volume withSecrets(List<SecretVolumeItem> secrets) {
        this.secrets = secrets;
        return this;
    }

    public String mountOptions() {
        return this.mountOptions;
    }

    public Volume withMountOptions(String mountOptions) {
        this.mountOptions = mountOptions;
        return this;
    }

    public void validate() {
        if (this.secrets() != null) {
            this.secrets().forEach(e -> e.validate());
        }
    }
}

