/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.applicationinsights.ApplicationInsightsManager;
import com.azure.resourcemanager.applicationinsights.fluent.ComponentQuotaStatusClient;
import com.azure.resourcemanager.applicationinsights.fluent.models.ApplicationInsightsComponentQuotaStatusInner;
import com.azure.resourcemanager.applicationinsights.implementation.ApplicationInsightsComponentQuotaStatusImpl;
import com.azure.resourcemanager.applicationinsights.models.ApplicationInsightsComponentQuotaStatus;
import com.azure.resourcemanager.applicationinsights.models.ComponentQuotaStatus;

public final class ComponentQuotaStatusImpl
implements ComponentQuotaStatus {
    private static final ClientLogger LOGGER = new ClientLogger(ComponentQuotaStatusImpl.class);
    private final ComponentQuotaStatusClient innerClient;
    private final ApplicationInsightsManager serviceManager;

    public ComponentQuotaStatusImpl(ComponentQuotaStatusClient innerClient, ApplicationInsightsManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<ApplicationInsightsComponentQuotaStatus> getWithResponse(String resourceGroupName, String resourceName, Context context) {
        Response<ApplicationInsightsComponentQuotaStatusInner> inner = this.serviceClient().getWithResponse(resourceGroupName, resourceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ApplicationInsightsComponentQuotaStatusImpl((ApplicationInsightsComponentQuotaStatusInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ApplicationInsightsComponentQuotaStatus get(String resourceGroupName, String resourceName) {
        ApplicationInsightsComponentQuotaStatusInner inner = this.serviceClient().get(resourceGroupName, resourceName);
        if (inner != null) {
            return new ApplicationInsightsComponentQuotaStatusImpl(inner, this.manager());
        }
        return null;
    }

    private ComponentQuotaStatusClient serviceClient() {
        return this.innerClient;
    }

    private ApplicationInsightsManager manager() {
        return this.serviceManager;
    }
}

