/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.applicationinsights.fluent.ProactiveDetectionConfigurationsClient;
import com.azure.resourcemanager.applicationinsights.fluent.models.ApplicationInsightsComponentProactiveDetectionConfigurationInner;
import com.azure.resourcemanager.applicationinsights.implementation.ApplicationInsightsManagementClientImpl;
import java.util.List;
import reactor.core.publisher.Mono;

public final class ProactiveDetectionConfigurationsClientImpl
implements ProactiveDetectionConfigurationsClient {
    private final ProactiveDetectionConfigurationsService service;
    private final ApplicationInsightsManagementClientImpl client;

    ProactiveDetectionConfigurationsClientImpl(ApplicationInsightsManagementClientImpl client) {
        this.service = (ProactiveDetectionConfigurationsService)RestProxy.create(ProactiveDetectionConfigurationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<ApplicationInsightsComponentProactiveDetectionConfigurationInner>>> listWithResponseAsync(String resourceGroupName, String resourceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String apiVersion = "2015-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), resourceGroupName, "2015-05-01", this.client.getSubscriptionId(), resourceName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<ApplicationInsightsComponentProactiveDetectionConfigurationInner>>> listWithResponseAsync(String resourceGroupName, String resourceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String apiVersion = "2015-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), resourceGroupName, "2015-05-01", this.client.getSubscriptionId(), resourceName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<List<ApplicationInsightsComponentProactiveDetectionConfigurationInner>> listAsync(String resourceGroupName, String resourceName) {
        return this.listWithResponseAsync(resourceGroupName, resourceName).flatMap(res -> Mono.justOrEmpty((Object)((List)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<ApplicationInsightsComponentProactiveDetectionConfigurationInner>> listWithResponse(String resourceGroupName, String resourceName, Context context) {
        return (Response)this.listWithResponseAsync(resourceGroupName, resourceName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<ApplicationInsightsComponentProactiveDetectionConfigurationInner> list(String resourceGroupName, String resourceName) {
        return (List)this.listWithResponse(resourceGroupName, resourceName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ApplicationInsightsComponentProactiveDetectionConfigurationInner>> getWithResponseAsync(String resourceGroupName, String resourceName, String configurationId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (configurationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter configurationId is required and cannot be null."));
        }
        String apiVersion = "2015-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, "2015-05-01", this.client.getSubscriptionId(), resourceName, configurationId, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ApplicationInsightsComponentProactiveDetectionConfigurationInner>> getWithResponseAsync(String resourceGroupName, String resourceName, String configurationId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (configurationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter configurationId is required and cannot be null."));
        }
        String apiVersion = "2015-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, "2015-05-01", this.client.getSubscriptionId(), resourceName, configurationId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ApplicationInsightsComponentProactiveDetectionConfigurationInner> getAsync(String resourceGroupName, String resourceName, String configurationId) {
        return this.getWithResponseAsync(resourceGroupName, resourceName, configurationId).flatMap(res -> Mono.justOrEmpty((Object)((ApplicationInsightsComponentProactiveDetectionConfigurationInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ApplicationInsightsComponentProactiveDetectionConfigurationInner> getWithResponse(String resourceGroupName, String resourceName, String configurationId, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, resourceName, configurationId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ApplicationInsightsComponentProactiveDetectionConfigurationInner get(String resourceGroupName, String resourceName, String configurationId) {
        return (ApplicationInsightsComponentProactiveDetectionConfigurationInner)this.getWithResponse(resourceGroupName, resourceName, configurationId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ApplicationInsightsComponentProactiveDetectionConfigurationInner>> updateWithResponseAsync(String resourceGroupName, String resourceName, String configurationId, ApplicationInsightsComponentProactiveDetectionConfigurationInner proactiveDetectionProperties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (configurationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter configurationId is required and cannot be null."));
        }
        if (proactiveDetectionProperties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter proactiveDetectionProperties is required and cannot be null."));
        }
        proactiveDetectionProperties.validate();
        String apiVersion = "2015-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), resourceGroupName, "2015-05-01", this.client.getSubscriptionId(), resourceName, configurationId, proactiveDetectionProperties, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ApplicationInsightsComponentProactiveDetectionConfigurationInner>> updateWithResponseAsync(String resourceGroupName, String resourceName, String configurationId, ApplicationInsightsComponentProactiveDetectionConfigurationInner proactiveDetectionProperties, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (configurationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter configurationId is required and cannot be null."));
        }
        if (proactiveDetectionProperties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter proactiveDetectionProperties is required and cannot be null."));
        }
        proactiveDetectionProperties.validate();
        String apiVersion = "2015-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), resourceGroupName, "2015-05-01", this.client.getSubscriptionId(), resourceName, configurationId, proactiveDetectionProperties, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ApplicationInsightsComponentProactiveDetectionConfigurationInner> updateAsync(String resourceGroupName, String resourceName, String configurationId, ApplicationInsightsComponentProactiveDetectionConfigurationInner proactiveDetectionProperties) {
        return this.updateWithResponseAsync(resourceGroupName, resourceName, configurationId, proactiveDetectionProperties).flatMap(res -> Mono.justOrEmpty((Object)((ApplicationInsightsComponentProactiveDetectionConfigurationInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ApplicationInsightsComponentProactiveDetectionConfigurationInner> updateWithResponse(String resourceGroupName, String resourceName, String configurationId, ApplicationInsightsComponentProactiveDetectionConfigurationInner proactiveDetectionProperties, Context context) {
        return (Response)this.updateWithResponseAsync(resourceGroupName, resourceName, configurationId, proactiveDetectionProperties, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ApplicationInsightsComponentProactiveDetectionConfigurationInner update(String resourceGroupName, String resourceName, String configurationId, ApplicationInsightsComponentProactiveDetectionConfigurationInner proactiveDetectionProperties) {
        return (ApplicationInsightsComponentProactiveDetectionConfigurationInner)this.updateWithResponse(resourceGroupName, resourceName, configurationId, proactiveDetectionProperties, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ApplicationInsightsM")
    public static interface ProactiveDetectionConfigurationsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/ProactiveDetectionConfigs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<List<ApplicationInsightsComponentProactiveDetectionConfigurationInner>>> list(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="resourceName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/ProactiveDetectionConfigs/{ConfigurationId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ApplicationInsightsComponentProactiveDetectionConfigurationInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="resourceName") String var5, @PathParam(value="ConfigurationId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/ProactiveDetectionConfigs/{ConfigurationId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ApplicationInsightsComponentProactiveDetectionConfigurationInner>> update(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="resourceName") String var5, @PathParam(value="ConfigurationId") String var6, @BodyParam(value="application/json") ApplicationInsightsComponentProactiveDetectionConfigurationInner var7, @HeaderParam(value="Accept") String var8, Context var9);
    }
}

