/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.implementation;

import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.applicationinsights.ApplicationInsightsManager;
import com.azure.resourcemanager.applicationinsights.fluent.models.WorkbookTemplateInner;
import com.azure.resourcemanager.applicationinsights.implementation.Utils;
import com.azure.resourcemanager.applicationinsights.models.WorkbookTemplate;
import com.azure.resourcemanager.applicationinsights.models.WorkbookTemplateGallery;
import com.azure.resourcemanager.applicationinsights.models.WorkbookTemplateLocalizedGallery;
import com.azure.resourcemanager.applicationinsights.models.WorkbookTemplateUpdateParameters;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class WorkbookTemplateImpl
implements WorkbookTemplate,
WorkbookTemplate.Definition,
WorkbookTemplate.Update {
    private WorkbookTemplateInner innerObject;
    private final ApplicationInsightsManager serviceManager;
    private String resourceGroupName;
    private String resourceName;
    private WorkbookTemplateUpdateParameters updateWorkbookTemplateUpdateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public Integer priority() {
        return this.innerModel().priority();
    }

    @Override
    public String author() {
        return this.innerModel().author();
    }

    @Override
    public Object templateData() {
        return this.innerModel().templateData();
    }

    @Override
    public List<WorkbookTemplateGallery> galleries() {
        List<WorkbookTemplateGallery> inner = this.innerModel().galleries();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, List<WorkbookTemplateLocalizedGallery>> localized() {
        Map<String, List<WorkbookTemplateLocalizedGallery>> inner = this.innerModel().localized();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public WorkbookTemplateInner innerModel() {
        return this.innerObject;
    }

    private ApplicationInsightsManager manager() {
        return this.serviceManager;
    }

    @Override
    public WorkbookTemplateImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public WorkbookTemplate create() {
        this.innerObject = (WorkbookTemplateInner)((Object)this.serviceManager.serviceClient().getWorkbookTemplates().createOrUpdateWithResponse(this.resourceGroupName, this.resourceName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public WorkbookTemplate create(Context context) {
        this.innerObject = (WorkbookTemplateInner)((Object)this.serviceManager.serviceClient().getWorkbookTemplates().createOrUpdateWithResponse(this.resourceGroupName, this.resourceName, this.innerModel(), context).getValue());
        return this;
    }

    WorkbookTemplateImpl(String name, ApplicationInsightsManager serviceManager) {
        this.innerObject = new WorkbookTemplateInner();
        this.serviceManager = serviceManager;
        this.resourceName = name;
    }

    @Override
    public WorkbookTemplateImpl update() {
        this.updateWorkbookTemplateUpdateParameters = new WorkbookTemplateUpdateParameters();
        return this;
    }

    @Override
    public WorkbookTemplate apply() {
        this.innerObject = (WorkbookTemplateInner)((Object)this.serviceManager.serviceClient().getWorkbookTemplates().updateWithResponse(this.resourceGroupName, this.resourceName, this.updateWorkbookTemplateUpdateParameters, Context.NONE).getValue());
        return this;
    }

    @Override
    public WorkbookTemplate apply(Context context) {
        this.innerObject = (WorkbookTemplateInner)((Object)this.serviceManager.serviceClient().getWorkbookTemplates().updateWithResponse(this.resourceGroupName, this.resourceName, this.updateWorkbookTemplateUpdateParameters, context).getValue());
        return this;
    }

    WorkbookTemplateImpl(WorkbookTemplateInner innerObject, ApplicationInsightsManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.resourceName = Utils.getValueFromIdByName(innerObject.id(), "workbooktemplates");
    }

    @Override
    public WorkbookTemplate refresh() {
        this.innerObject = (WorkbookTemplateInner)((Object)this.serviceManager.serviceClient().getWorkbookTemplates().getByResourceGroupWithResponse(this.resourceGroupName, this.resourceName, Context.NONE).getValue());
        return this;
    }

    @Override
    public WorkbookTemplate refresh(Context context) {
        this.innerObject = (WorkbookTemplateInner)((Object)this.serviceManager.serviceClient().getWorkbookTemplates().getByResourceGroupWithResponse(this.resourceGroupName, this.resourceName, context).getValue());
        return this;
    }

    @Override
    public WorkbookTemplateImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public WorkbookTemplateImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public WorkbookTemplateImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateWorkbookTemplateUpdateParameters.withTags(tags);
        return this;
    }

    @Override
    public WorkbookTemplateImpl withPriority(Integer priority) {
        if (this.isInCreateMode()) {
            this.innerModel().withPriority(priority);
            return this;
        }
        this.updateWorkbookTemplateUpdateParameters.withPriority(priority);
        return this;
    }

    @Override
    public WorkbookTemplateImpl withAuthor(String author) {
        if (this.isInCreateMode()) {
            this.innerModel().withAuthor(author);
            return this;
        }
        this.updateWorkbookTemplateUpdateParameters.withAuthor(author);
        return this;
    }

    @Override
    public WorkbookTemplateImpl withTemplateData(Object templateData) {
        if (this.isInCreateMode()) {
            this.innerModel().withTemplateData(templateData);
            return this;
        }
        this.updateWorkbookTemplateUpdateParameters.withTemplateData(templateData);
        return this;
    }

    @Override
    public WorkbookTemplateImpl withGalleries(List<WorkbookTemplateGallery> galleries) {
        if (this.isInCreateMode()) {
            this.innerModel().withGalleries(galleries);
            return this;
        }
        this.updateWorkbookTemplateUpdateParameters.withGalleries(galleries);
        return this;
    }

    @Override
    public WorkbookTemplateImpl withLocalized(Map<String, List<WorkbookTemplateLocalizedGallery>> localized) {
        if (this.isInCreateMode()) {
            this.innerModel().withLocalized(localized);
            return this;
        }
        this.updateWorkbookTemplateUpdateParameters.withLocalized(localized);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

