/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appplatform.models.ApmProvisioningState;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class ApmProperties {
    @JsonProperty(value="type", required=true)
    private String type;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ApmProvisioningState provisioningState;
    @JsonProperty(value="properties")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> properties;
    @JsonProperty(value="secrets")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> secrets;
    private static final ClientLogger LOGGER = new ClientLogger(ApmProperties.class);

    public String type() {
        return this.type;
    }

    public ApmProperties withType(String type) {
        this.type = type;
        return this;
    }

    public ApmProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public ApmProperties withProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public Map<String, String> secrets() {
        return this.secrets;
    }

    public ApmProperties withSecrets(Map<String, String> secrets) {
        this.secrets = secrets;
        return this;
    }

    public void validate() {
        if (this.type() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property type in model ApmProperties"));
        }
    }
}

