/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.resourcemanager.appplatform.models.ApmReference;
import com.azure.resourcemanager.appplatform.models.BuildProvisioningState;
import com.azure.resourcemanager.appplatform.models.BuildResourceRequests;
import com.azure.resourcemanager.appplatform.models.CertificateReference;
import com.azure.resourcemanager.appplatform.models.TriggeredBuildResult;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class BuildProperties {
    @JsonProperty(value="relativePath")
    private String relativePath;
    @JsonProperty(value="builder")
    private String builder;
    @JsonProperty(value="agentPool")
    private String agentPool;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private BuildProvisioningState provisioningState;
    @JsonProperty(value="env")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> env;
    @JsonProperty(value="apms")
    private List<ApmReference> apms;
    @JsonProperty(value="certificates")
    private List<CertificateReference> certificates;
    @JsonProperty(value="triggeredBuildResult", access=JsonProperty.Access.WRITE_ONLY)
    private TriggeredBuildResult triggeredBuildResult;
    @JsonProperty(value="resourceRequests")
    private BuildResourceRequests resourceRequests;

    public String relativePath() {
        return this.relativePath;
    }

    public BuildProperties withRelativePath(String relativePath) {
        this.relativePath = relativePath;
        return this;
    }

    public String builder() {
        return this.builder;
    }

    public BuildProperties withBuilder(String builder) {
        this.builder = builder;
        return this;
    }

    public String agentPool() {
        return this.agentPool;
    }

    public BuildProperties withAgentPool(String agentPool) {
        this.agentPool = agentPool;
        return this;
    }

    public BuildProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Map<String, String> env() {
        return this.env;
    }

    public BuildProperties withEnv(Map<String, String> env) {
        this.env = env;
        return this;
    }

    public List<ApmReference> apms() {
        return this.apms;
    }

    public BuildProperties withApms(List<ApmReference> apms) {
        this.apms = apms;
        return this;
    }

    public List<CertificateReference> certificates() {
        return this.certificates;
    }

    public BuildProperties withCertificates(List<CertificateReference> certificates) {
        this.certificates = certificates;
        return this;
    }

    public TriggeredBuildResult triggeredBuildResult() {
        return this.triggeredBuildResult;
    }

    public BuildResourceRequests resourceRequests() {
        return this.resourceRequests;
    }

    public BuildProperties withResourceRequests(BuildResourceRequests resourceRequests) {
        this.resourceRequests = resourceRequests;
        return this;
    }

    public void validate() {
        if (this.apms() != null) {
            this.apms().forEach(e -> e.validate());
        }
        if (this.certificates() != null) {
            this.certificates().forEach(e -> e.validate());
        }
        if (this.triggeredBuildResult() != null) {
            this.triggeredBuildResult().validate();
        }
        if (this.resourceRequests() != null) {
            this.resourceRequests().validate();
        }
    }
}

