/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.models.CustomDomainHttpsParameters;
import com.azure.resourcemanager.cdn.models.CustomDomainResourceState;
import com.azure.resourcemanager.cdn.models.CustomHttpsProvisioningState;
import com.azure.resourcemanager.cdn.models.CustomHttpsProvisioningSubstate;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class CustomDomainProperties {
    @JsonProperty(value="hostName", required=true)
    private String hostname;
    @JsonProperty(value="resourceState", access=JsonProperty.Access.WRITE_ONLY)
    private CustomDomainResourceState resourceState;
    @JsonProperty(value="customHttpsProvisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private CustomHttpsProvisioningState customHttpsProvisioningState;
    @JsonProperty(value="customHttpsProvisioningSubstate", access=JsonProperty.Access.WRITE_ONLY)
    private CustomHttpsProvisioningSubstate customHttpsProvisioningSubstate;
    @JsonProperty(value="customHttpsParameters")
    private CustomDomainHttpsParameters customHttpsParameters;
    @JsonProperty(value="validationData")
    private String validationData;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private CustomHttpsProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(CustomDomainProperties.class);

    public String hostname() {
        return this.hostname;
    }

    public CustomDomainProperties withHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public CustomDomainResourceState resourceState() {
        return this.resourceState;
    }

    public CustomHttpsProvisioningState customHttpsProvisioningState() {
        return this.customHttpsProvisioningState;
    }

    public CustomHttpsProvisioningSubstate customHttpsProvisioningSubstate() {
        return this.customHttpsProvisioningSubstate;
    }

    public CustomDomainHttpsParameters customHttpsParameters() {
        return this.customHttpsParameters;
    }

    public CustomDomainProperties withCustomHttpsParameters(CustomDomainHttpsParameters customHttpsParameters) {
        this.customHttpsParameters = customHttpsParameters;
        return this;
    }

    public String validationData() {
        return this.validationData;
    }

    public CustomDomainProperties withValidationData(String validationData) {
        this.validationData = validationData;
        return this;
    }

    public CustomHttpsProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.hostname() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property hostname in model CustomDomainProperties"));
        }
        if (this.customHttpsParameters() != null) {
            this.customHttpsParameters().validate();
        }
    }
}

