/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.resourcemanager.compute.fluent.models.VirtualMachineImageProperties;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineImageResourceInner;
import com.azure.resourcemanager.compute.models.ArchitectureTypes;
import com.azure.resourcemanager.compute.models.AutomaticOSUpgradeProperties;
import com.azure.resourcemanager.compute.models.DataDiskImage;
import com.azure.resourcemanager.compute.models.DisallowedConfiguration;
import com.azure.resourcemanager.compute.models.ExtendedLocation;
import com.azure.resourcemanager.compute.models.HyperVGenerationTypes;
import com.azure.resourcemanager.compute.models.ImageDeprecationStatus;
import com.azure.resourcemanager.compute.models.OSDiskImage;
import com.azure.resourcemanager.compute.models.PurchasePlan;
import com.azure.resourcemanager.compute.models.VirtualMachineImageFeature;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class VirtualMachineImageInner
extends VirtualMachineImageResourceInner {
    @JsonProperty(value="properties")
    private VirtualMachineImageProperties innerProperties;

    private VirtualMachineImageProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public VirtualMachineImageInner withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public VirtualMachineImageInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public VirtualMachineImageInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    @Override
    public VirtualMachineImageInner withExtendedLocation(ExtendedLocation extendedLocation) {
        super.withExtendedLocation(extendedLocation);
        return this;
    }

    @Override
    public VirtualMachineImageInner withId(String id) {
        super.withId(id);
        return this;
    }

    public PurchasePlan plan() {
        return this.innerProperties() == null ? null : this.innerProperties().plan();
    }

    public VirtualMachineImageInner withPlan(PurchasePlan plan) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineImageProperties();
        }
        this.innerProperties().withPlan(plan);
        return this;
    }

    public OSDiskImage osDiskImage() {
        return this.innerProperties() == null ? null : this.innerProperties().osDiskImage();
    }

    public VirtualMachineImageInner withOsDiskImage(OSDiskImage osDiskImage) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineImageProperties();
        }
        this.innerProperties().withOsDiskImage(osDiskImage);
        return this;
    }

    public List<DataDiskImage> dataDiskImages() {
        return this.innerProperties() == null ? null : this.innerProperties().dataDiskImages();
    }

    public VirtualMachineImageInner withDataDiskImages(List<DataDiskImage> dataDiskImages) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineImageProperties();
        }
        this.innerProperties().withDataDiskImages(dataDiskImages);
        return this;
    }

    public AutomaticOSUpgradeProperties automaticOSUpgradeProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().automaticOSUpgradeProperties();
    }

    public VirtualMachineImageInner withAutomaticOSUpgradeProperties(AutomaticOSUpgradeProperties automaticOSUpgradeProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineImageProperties();
        }
        this.innerProperties().withAutomaticOSUpgradeProperties(automaticOSUpgradeProperties);
        return this;
    }

    public HyperVGenerationTypes hyperVGeneration() {
        return this.innerProperties() == null ? null : this.innerProperties().hyperVGeneration();
    }

    public VirtualMachineImageInner withHyperVGeneration(HyperVGenerationTypes hyperVGeneration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineImageProperties();
        }
        this.innerProperties().withHyperVGeneration(hyperVGeneration);
        return this;
    }

    public DisallowedConfiguration disallowed() {
        return this.innerProperties() == null ? null : this.innerProperties().disallowed();
    }

    public VirtualMachineImageInner withDisallowed(DisallowedConfiguration disallowed) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineImageProperties();
        }
        this.innerProperties().withDisallowed(disallowed);
        return this;
    }

    public List<VirtualMachineImageFeature> features() {
        return this.innerProperties() == null ? null : this.innerProperties().features();
    }

    public VirtualMachineImageInner withFeatures(List<VirtualMachineImageFeature> features) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineImageProperties();
        }
        this.innerProperties().withFeatures(features);
        return this;
    }

    public ArchitectureTypes architecture() {
        return this.innerProperties() == null ? null : this.innerProperties().architecture();
    }

    public VirtualMachineImageInner withArchitecture(ArchitectureTypes architecture) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineImageProperties();
        }
        this.innerProperties().withArchitecture(architecture);
        return this;
    }

    public ImageDeprecationStatus imageDeprecationStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().imageDeprecationStatus();
    }

    public VirtualMachineImageInner withImageDeprecationStatus(ImageDeprecationStatus imageDeprecationStatus) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineImageProperties();
        }
        this.innerProperties().withImageDeprecationStatus(imageDeprecationStatus);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

