/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.http.rest.PagedFlux;
import com.azure.resourcemanager.containerregistry.ContainerRegistryManager;
import com.azure.resourcemanager.containerregistry.fluent.models.RegistryInner;
import com.azure.resourcemanager.containerregistry.models.AccessKeyType;
import com.azure.resourcemanager.containerregistry.models.NetworkRuleSet;
import com.azure.resourcemanager.containerregistry.models.PublicNetworkAccess;
import com.azure.resourcemanager.containerregistry.models.RegistryCredentials;
import com.azure.resourcemanager.containerregistry.models.RegistryTaskRun;
import com.azure.resourcemanager.containerregistry.models.RegistryUsage;
import com.azure.resourcemanager.containerregistry.models.Sku;
import com.azure.resourcemanager.containerregistry.models.SourceUploadDefinition;
import com.azure.resourcemanager.containerregistry.models.Webhook;
import com.azure.resourcemanager.containerregistry.models.WebhookOperations;
import com.azure.resourcemanager.resources.fluentcore.arm.models.GroupableResource;
import com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.azure.resourcemanager.resources.fluentcore.collection.SupportsListingPrivateEndpointConnection;
import com.azure.resourcemanager.resources.fluentcore.collection.SupportsListingPrivateLinkResource;
import com.azure.resourcemanager.resources.fluentcore.collection.SupportsUpdatingPrivateEndpointConnection;
import com.azure.resourcemanager.resources.fluentcore.model.Appliable;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.Refreshable;
import com.azure.resourcemanager.resources.fluentcore.model.Updatable;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.List;
import reactor.core.publisher.Mono;

public interface Registry
extends GroupableResource<ContainerRegistryManager, RegistryInner>,
Refreshable<Registry>,
Updatable<Update>,
SupportsListingPrivateLinkResource,
SupportsListingPrivateEndpointConnection,
SupportsUpdatingPrivateEndpointConnection {
    public Sku sku();

    public String loginServerUrl();

    public OffsetDateTime creationDate();

    public boolean adminUserEnabled();

    public RegistryCredentials getCredentials();

    public Mono<RegistryCredentials> getCredentialsAsync();

    public RegistryCredentials regenerateCredential(AccessKeyType var1);

    public Mono<RegistryCredentials> regenerateCredentialAsync(AccessKeyType var1);

    public Collection<RegistryUsage> listQuotaUsages();

    public PagedFlux<RegistryUsage> listQuotaUsagesAsync();

    public SourceUploadDefinition getBuildSourceUploadUrl();

    public Mono<SourceUploadDefinition> getBuildSourceUploadUrlAsync();

    public WebhookOperations webhooks();

    public PublicNetworkAccess publicNetworkAccess();

    public boolean canAccessFromTrustedServices();

    public NetworkRuleSet networkRuleSet();

    public boolean isDedicatedDataEndpointsEnabled();

    public boolean isZoneRedundancyEnabled();

    public List<String> dedicatedDataEndpointsHostNames();

    public RegistryTaskRun.DefinitionStages.BlankFromRegistry scheduleRun();

    public static interface UpdateStages {

        public static interface WithDedicatedDataEndpoints {
            public Update enableDedicatedDataEndpoints();

            public Update disableDedicatedDataEndpoints();
        }

        public static interface WithPublicNetworkAccess {
            public Update enablePublicNetworkAccess();

            public Update disablePublicNetworkAccess();

            public Update withAccessFromSelectedNetworks();

            public Update withAccessFromAllNetworks();

            public Update withAccessFromIpAddressRange(String var1);

            public Update withoutAccessFromIpAddressRange(String var1);

            public Update withAccessFromIpAddress(String var1);

            public Update withoutAccessFromIpAddress(String var1);

            public Update withAccessFromTrustedServices();

            public Update withoutAccessFromTrustedServices();
        }

        public static interface WithWebhook {
            public Webhook.UpdateDefinitionStages.Blank<Update> defineWebhook(String var1);

            public Update withoutWebhook(String var1);

            public Webhook.UpdateResourceStages.Blank<Update> updateWebhook(String var1);
        }

        public static interface WithSku {
            public Update withBasicSku();

            public Update withStandardSku();

            public Update withPremiumSku();
        }

        public static interface WithAdminUserEnabled {
            public Update withRegistryNameAsAdminUser();

            public Update withoutRegistryNameAsAdminUser();
        }
    }

    public static interface Update
    extends Resource.UpdateWithTags<Update>,
    Appliable<Registry>,
    UpdateStages.WithAdminUserEnabled,
    UpdateStages.WithSku,
    UpdateStages.WithWebhook,
    UpdateStages.WithDedicatedDataEndpoints,
    UpdateStages.WithPublicNetworkAccess {
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<Registry>,
        WithAdminUserEnabled,
        WithWebhook,
        WithPublicNetworkAccess,
        WithDedicatedDataEndpoints,
        WithZoneRedundancy,
        Resource.DefinitionWithTags<WithCreate> {
        }

        public static interface WithZoneRedundancy {
            public WithCreate withZoneRedundancy();
        }

        public static interface WithDedicatedDataEndpoints {
            public WithCreate enableDedicatedDataEndpoints();
        }

        public static interface WithPublicNetworkAccess {
            public WithCreate disablePublicNetworkAccess();

            public WithCreate withAccessFromSelectedNetworks();

            public WithCreate withAccessFromIpAddressRange(String var1);

            public WithCreate withAccessFromIpAddress(String var1);

            public WithCreate withAccessFromTrustedServices();
        }

        public static interface WithWebhook {
            public Webhook.DefinitionStages.Blank<WithCreate> defineWebhook(String var1);
        }

        public static interface WithAdminUserEnabled {
            public WithCreate withRegistryNameAsAdminUser();
        }

        public static interface WithSku {
            public WithCreate withBasicSku();

            public WithCreate withStandardSku();

            public WithCreate withPremiumSku();
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithSku> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithSku,
    DefinitionStages.WithCreate {
    }
}

