/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.iothub.IotHubManager;
import com.azure.resourcemanager.iothub.fluent.models.EventHubConsumerGroupInfoInner;
import com.azure.resourcemanager.iothub.models.EventHubConsumerGroupBodyDescription;
import com.azure.resourcemanager.iothub.models.EventHubConsumerGroupInfo;
import com.azure.resourcemanager.iothub.models.EventHubConsumerGroupName;
import java.util.Collections;
import java.util.Map;

public final class EventHubConsumerGroupInfoImpl
implements EventHubConsumerGroupInfo,
EventHubConsumerGroupInfo.Definition {
    private EventHubConsumerGroupInfoInner innerObject;
    private final IotHubManager serviceManager;
    private String resourceGroupName;
    private String resourceName;
    private String eventHubEndpointName;
    private String name;
    private EventHubConsumerGroupBodyDescription createConsumerGroupBody;

    EventHubConsumerGroupInfoImpl(EventHubConsumerGroupInfoInner innerObject, IotHubManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public Map<String, Object> properties() {
        Map<String, Object> inner = this.innerModel().properties();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public EventHubConsumerGroupInfoInner innerModel() {
        return this.innerObject;
    }

    private IotHubManager manager() {
        return this.serviceManager;
    }

    @Override
    public EventHubConsumerGroupInfoImpl withExistingEventHubEndpoint(String resourceGroupName, String resourceName, String eventHubEndpointName) {
        this.resourceGroupName = resourceGroupName;
        this.resourceName = resourceName;
        this.eventHubEndpointName = eventHubEndpointName;
        return this;
    }

    @Override
    public EventHubConsumerGroupInfo create() {
        this.innerObject = (EventHubConsumerGroupInfoInner)((Object)this.serviceManager.serviceClient().getIotHubResources().createEventHubConsumerGroupWithResponse(this.resourceGroupName, this.resourceName, this.eventHubEndpointName, this.name, this.createConsumerGroupBody, Context.NONE).getValue());
        return this;
    }

    @Override
    public EventHubConsumerGroupInfo create(Context context) {
        this.innerObject = (EventHubConsumerGroupInfoInner)((Object)this.serviceManager.serviceClient().getIotHubResources().createEventHubConsumerGroupWithResponse(this.resourceGroupName, this.resourceName, this.eventHubEndpointName, this.name, this.createConsumerGroupBody, context).getValue());
        return this;
    }

    EventHubConsumerGroupInfoImpl(String name, IotHubManager serviceManager) {
        this.innerObject = new EventHubConsumerGroupInfoInner();
        this.serviceManager = serviceManager;
        this.name = name;
        this.createConsumerGroupBody = new EventHubConsumerGroupBodyDescription();
    }

    @Override
    public EventHubConsumerGroupInfo refresh() {
        this.innerObject = (EventHubConsumerGroupInfoInner)((Object)this.serviceManager.serviceClient().getIotHubResources().getEventHubConsumerGroupWithResponse(this.resourceGroupName, this.resourceName, this.eventHubEndpointName, this.name, Context.NONE).getValue());
        return this;
    }

    @Override
    public EventHubConsumerGroupInfo refresh(Context context) {
        this.innerObject = (EventHubConsumerGroupInfoInner)((Object)this.serviceManager.serviceClient().getIotHubResources().getEventHubConsumerGroupWithResponse(this.resourceGroupName, this.resourceName, this.eventHubEndpointName, this.name, context).getValue());
        return this;
    }

    @Override
    public EventHubConsumerGroupInfoImpl withProperties(EventHubConsumerGroupName properties) {
        this.createConsumerGroupBody.withProperties(properties);
        return this;
    }
}

