/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.implementation;

import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.iothub.IotHubManager;
import com.azure.resourcemanager.iothub.fluent.IotHubsClient;
import com.azure.resourcemanager.iothub.models.FailoverInput;
import com.azure.resourcemanager.iothub.models.IotHubs;

public final class IotHubsImpl
implements IotHubs {
    private static final ClientLogger LOGGER = new ClientLogger(IotHubsImpl.class);
    private final IotHubsClient innerClient;
    private final IotHubManager serviceManager;

    public IotHubsImpl(IotHubsClient innerClient, IotHubManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public void manualFailover(String iotHubName, String resourceGroupName, FailoverInput failoverInput) {
        this.serviceClient().manualFailover(iotHubName, resourceGroupName, failoverInput);
    }

    @Override
    public void manualFailover(String iotHubName, String resourceGroupName, FailoverInput failoverInput, Context context) {
        this.serviceClient().manualFailover(iotHubName, resourceGroupName, failoverInput, context);
    }

    private IotHubsClient serviceClient() {
        return this.innerClient;
    }

    private IotHubManager manager() {
        return this.serviceManager;
    }
}

